
// K. Harrison 13/10/94.
// Rough and ready benchmarking...

#include <iostream.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <bios.h>

#include "fixed32.h"

void bench_add(void);
void bench_sub(void);
void bench_mul(void);
void bench_div(void);
void bench_recip(void);
void bench_square(void);
void bench_sqrt_hp(void);
void bench_sqrt_lp(void);

const int SEED = 1;
long ITERATIONS = 1276700L;

int main (void)
{

  cout << "\nEnter number of times to do each test.\n";
  cout << "Recommended:  200000 for 486sx   25mhz,\n";
  cout << "           : 1500000 for Pentium 90mhz\n";
  cout << "How many ? ";
  cin  >> ITERATIONS;
  cout << "\nEach test will be performed " << ITERATIONS << " times\n";

  cout << "\nThe results of each test is in CLOCK TICKS (approx 18.2 per second),\n";
  cout << "but we only need to know relative speeds...\n\n";
  cout << "Base   = baseline (time taken to call & return from functions).\n";
  cout << "Float  = In-built co-processor if you have one, otherwise emulation.\n";
  cout << "Fixed  = My fixed-point routines\n\n";
  cout << "Note: we are currently using " << PRECISIONBITS
       << " bits of fractional precision, but\n"
       << "      this can be altered at compile time\n\n";

  cout << "                               Base, Float, Fixed\n";
  cout << "                               ----------------------\n";

  bench_add();
  bench_sub();
  bench_mul();
  bench_div();
  bench_recip();
  bench_square();
  bench_sqrt_hp();
  bench_sqrt_lp();

  return 0;
}

void bench_add(void)
{
  float fl1, fl2, fl3;
  fixed32 fx1, fx2, fx3;

  cout << "Add                            | ";

  srand(SEED);
  long overhead = 0;
  for (int i=0; i<3; i++)
  {
    long timer = biostime(_TIME_GETCLOCK, 0);
    for (long j=0; j<ITERATIONS; j++)
    {
      int n1 = rand();
      int n2 = rand();
      fl1 = n1;
      fl2 = n2;
      fx1 = n1;
      fx2 = n2;
      switch (i) {
	case 0: ;break;
	case 1: fl3 = fl1 + fl2; break;
	case 2: fx3 = fx1 + fx2; break;
      }
    }
    timer = biostime(_TIME_GETCLOCK, 0) - timer - overhead;

    cout << timer;
    switch (i) {
      case 0:  overhead = timer;
	       cout << " , ";
	       break;
      case 1:  cout << " , ";
	       break;
      default: break;
    }
  }
  cout << "\n";
}

void bench_sub(void)
{
  float fl1, fl2, fl3;
  fixed32 fx1, fx2, fx3;

  cout << "Subtract                       | ";

  srand(SEED);
  long overhead = 0;
  for (int i=0; i<3; i++)
  {
    long timer = biostime(_TIME_GETCLOCK, 0);
    for (long j=0; j<ITERATIONS; j++)
    {
      int n1 = rand();
      int n2 = rand();
      fl1 = n1;
      fl2 = n2;
      fx1 = n1;
      fx2 = n2;
      switch (i) {
	case 0: ;break;
	case 1: fl3 = fl1 - fl2; break;
	case 2: fx3 = fx1 - fx2; break;
      }
    }
    timer = biostime(_TIME_GETCLOCK, 0) - timer - overhead;

    cout << timer;
    switch (i) {
      case 0:  overhead = timer;
	       cout << " , ";
	       break;
      case 1:  cout << " , ";
	       break;
      default: break;
    }
  }
  cout << "\n";
}

void bench_mul(void)
{
  float fl1, fl2, fl3;
  fixed32 fx1, fx2, fx3;

  cout << "Multiply                       | ";

  srand(SEED);
  long overhead = 0;
  for (int i=0; i<3; i++)
  {
    long timer = biostime(_TIME_GETCLOCK, 0);
    for (long j=0; j<ITERATIONS; j++)
    {
      int n1 = rand();
      int n2 = rand();
      fl1 = n1;
      fl2 = n2;
      fx1 = n1;
      fx2 = n2;
      switch (i) {
	case 0: ;break;
	case 1: fl3 = fl1 * fl2; break;
	case 2: fx3 = fx1 * fx2; break;
      }
    }
    timer = biostime(_TIME_GETCLOCK, 0) - timer - overhead;

    cout << timer;
    switch (i) {
      case 0:  overhead = timer;
	       cout << " , ";
	       break;
      case 1:  cout << " , ";
	       break;
      default: break;
    }
  }
  cout << "\n";
}

void bench_div(void)
{
  float fl1, fl2, fl3;
  fixed32 fx1, fx2, fx3;

  cout << "Divide                         | ";

  srand(SEED);
  long overhead = 0;
  for (int i=0; i<3; i++)
  {
    long timer = biostime(_TIME_GETCLOCK, 0);
    for (long j=0; j<ITERATIONS; j++)
    {
      int n1 = rand();
      int n2 = rand();
      if (n2 != 0) {
	fl1 = n1;
	fl2 = n2;
	fx1 = n1;
	fx2 = n2;
	switch (i) {
	  case 0: ;break;
	  case 1: fl3 = fl1 / fl2; break;
	  case 2: fx3 = fx1 / fx2; break;
	}
      }
    }
    timer = biostime(_TIME_GETCLOCK, 0) - timer - overhead;

    cout << timer;
    switch (i) {
      case 0:  overhead = timer;
	       cout << " , ";
	       break;
      case 1:  cout << " , ";
	       break;
      default: break;
    }
  }
  cout << "\n";
}

void bench_recip(void)
{
  float fl1, fl2;
  fixed32 fx1, fx2;

  cout << "Reciprocal (1 / n )            | ";

  srand(SEED);
  long overhead = 0;
  for (int i=0; i<3; i++)
  {
    long timer = biostime(_TIME_GETCLOCK, 0);
    for (long j=0; j<ITERATIONS; j++)
    {
      int n1 = rand();
      if (n1) {
	fl1 = n1;
	fx1 = n1;
	switch (i) {
	  case 0: ;break;
	  case 1: fl2 = 1 / fl1; break;
	  case 2: fx2 = recip(fx1); break;
	}
      }
    }
    timer = biostime(_TIME_GETCLOCK, 0) - timer - overhead;

    cout << timer;
    switch (i) {
      case 0:  overhead = timer;
	       cout << " , ";
	       break;
      case 1:  cout << " , ";
	       break;
      default: break;
    }
  }
  cout << "\n";
}

void bench_square(void)
{
  float fl1, fl2;
  fixed32 fx1, fx2;

  cout << "Square                         | ";

  srand(SEED);
  long overhead = 0;
  for (int i=0; i<3; i++)
  {
    long timer = biostime(_TIME_GETCLOCK, 0);
    for (long j=0; j<ITERATIONS; j++)
    {
      int n1 = rand();
	fl1 = n1;
	fx1 = n1;
	switch (i) {
	  case 0: ;break;
	  case 1: fl2 = fl1 * fl1; break;
	  case 2: fx2 = square(fx1); break;
	}
    }
    timer = biostime(_TIME_GETCLOCK, 0) - timer - overhead;

    cout << timer;
    switch (i) {
      case 0:  overhead = timer;
	       cout << " , ";
	       break;
      case 1:  cout << " , ";
	       break;
      default: break;
    }
  }
  cout << "\n";
}

void bench_sqrt_hp(void)
{
  float fl1, fl2;
  fixed32 fx1, fx2;

  cout << "Square root (normal precision) | ";

  srand(SEED);
  long overhead = 0;
  for (int i=0; i<3; i++)
  {
    long timer = biostime(_TIME_GETCLOCK, 0);
    for (long j=0; j<ITERATIONS; j++)
    {
      int n1 = rand();
      int n2 = rand();
      if (n2 != 0) {
	fl1 = n1;
	fx1 = n1;
	switch (i) {
	  case 0: ;break;
	  case 1: fl2 = sqrt(fl1); break;
	  case 2: fx2 = sqrt_np(fx1); break;
	}
      }
    }
    timer = biostime(_TIME_GETCLOCK, 0) - timer - overhead;

    cout << timer;
    switch (i) {
      case 0:  overhead = timer;
	       cout << " , ";
	       break;
      case 1:  cout << " , ";
	       break;
      default: break;
    }
  }
  cout << "\n";
}

void bench_sqrt_lp(void)
{
  float fl1, fl2;
  fixed32 fx1, fx2;

  cout << "Square root (low precision)    | ";

  srand(SEED);
  long overhead = 0;
  for (int i=0; i<3; i++)
  {
    long timer = biostime(_TIME_GETCLOCK, 0);
    for (long j=0; j<ITERATIONS; j++)
    {
      int n1 = rand();
      int n2 = rand();
      if (n2 != 0) {
	fl1 = n1;
	fx1 = n1;
	switch (i) {
	  case 0: ;break;
	  case 1: fl2 = sqrt(fl1); break;
	  case 2: fx2 = sqrt_lp(fx1); break;
	  //case 2: fx2 = sqrt2(fx1); break;
	}
      }
    }
    timer = biostime(_TIME_GETCLOCK, 0) - timer - overhead;

    cout << timer;
    switch (i) {
      case 0:  overhead = timer;
	       cout << " , ";
	       break;
      case 1:  cout << " , ";
	       break;
      default: break;
    }
  }
  cout << "\n";
}
