/* FFT86T3.C: Show how to call complex-to-complex FFTs like cfft2d.*/

#include <stdio.h>
#include <stdlib.h>
#include <fft86.h>

double darray[8] = {1.,0., 0.,0., -1.,0., 0.,0.}; /* lowest sine wave */
int n = 4, iforward = 1, iinverse = -1, iretcode;

void printcmplx (char * ctitle, int n, double far * pdarray, int icode)
{
int i;
printf ("n=%d, icode=%d.  %s \n", n, icode, ctitle);
for (i=0; i<(n*2); ++i)
    {printf ("%5.2f ", *(pdarray+i) );}
printf ("\n");
return;
}

void main ()
{
printf("Test starting\n");
printcmplx ("Input to cfft2d forward:",n,darray,0);
iretcode = cfft2d (darray, n, iforward);
printcmplx ("Output from cfft2d forward:",n,darray,iretcode);
iretcode = cfft2d (darray, n, iinverse);
printcmplx ("Output from cfft2d inverse:",n,darray,iretcode);
printf ("Test ending\n");
return;
}
