/* FFT86T5.C: Show how to call wkaiser & real-to-complex FFTs like rfft2f.*/

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <fft86.h>

float *pfarray, *pfwindow;
int n = 8, iforward = 1, iinverse = -1, iretcode;

void printreal (char * ctitle, int n, float far * pfarray, int icode)
{
int i;
printf ("n=%d, icode=%d.  %s \n", n, icode, ctitle);
for (i=0; i<n; ++i)
    {printf ("%5.2f ", *(pfarray+i) );}
printf ("\n");
return;
}

void main ()
{
int i;
printf	  ("Test starting\n");

pfarray  = (float *) calloc(n, sizeof(float));	/*get memory for data*/
for (i=0; i<n; ++i)
    *(pfarray+i) = (float) 2.0;	/*load data array with D.C. (all 2.0)*/

pfwindow = (float *) calloc (n, sizeof(float));	/*get memory for window*/
wkaiserf (pfwindow, n, 2.5);  /*load window array with Kaiser weights*/

for (i=0; i<n; ++i)
    *(pfarray+i) *= *(pfwindow+i);  /*multiply data and window function*/
free (pfwindow);  /*window array no longer needed*/

printreal ("Input to rfft2f forward:",n,pfarray,0);
iretcode = rfft2f (pfarray, n, iforward);
printreal ("Output from rfft2f forward:",n,pfarray,iretcode);
iretcode = rfft2f (pfarray, n, iinverse);
printreal ("Output from rfft2f inverse:",n,pfarray,iretcode);
printf	  ("Test ending\n");
free (pfarray);
return;
}
