/* FFT86T4.C:  Show how to call real-to-complex FFTs like rfft2f.*/

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <fft86.h>

float * pfarray;
int n = 8, iforward = 1, iinverse = -1, iretcode;

void printreal (char * ctitle, int n, float far * pfarray, int icode)
{
int i;
printf ("n=%d, icode=%d.  %s \n", n, icode, ctitle);
for (i=0; i<n; ++i)
    {printf ("%5.2f ", *(pfarray+i) );}
printf ("\n");
return;
}

void main ()
{
pfarray = (float *) calloc(n, sizeof(float));  /*get memory*/
*pfarray = (float) 1.;	/*load array with unit delta function (a spike) */
printf	  ("Test starting\n");
printreal ("Input to rfft2f forward:",n,pfarray,0);
iretcode = rfft2f (pfarray, n, iforward);
printreal ("Output from rfft2f forward:",n,pfarray,iretcode);
iretcode = rfft2f (pfarray, n, iinverse);
printreal ("Output from rfft2f inverse:",n,pfarray,iretcode);
printf	  ("Test ending\n");
free (pfarray);
return;
}
