/***************************************************************************

   Faxdecoder : Usage faxdecoder <compressed_fax >uncompressed.fax

   This program compresses a fax using a model based on an order 16 model.
   Context is as follows : C = Context bits, P = bit being predicted

	  			   x
				xxxxxx
				xxxxxx
				xxxP

   Variable names beginning with capital letters are arithmetic coding
   variables used by the arithmetic coding routines.

			-------------------------------

   Copyright Raymond P. Wilson 1989.

   This program is a shareware program. If you use it then credit must be
   given to the author (me). If you find this program useful please send
   whatever you think it is worth ($25 is suggested) to :

			Raymond P. Wilson
			38 Paremata St
			Atawhai
			Nelson
			New Zealand

 **************************************************************************/
 
#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "coderdef.i"	    /* My faxcoder definitions etc... */
#include "arithdec.i" /* Arithmetic decoding functions and defs ... */

/*************************************************************************

   Function   : Initialise_model
   Parameters : None
   Returns    : Nothing

   Initialise_model sets up all the structures and initialisation
 required by the fax coder. 

 ************************************************************************/

void initialise_model()
{
   int i;

   /* Initialise context bits and saved context arrays */
  
   for (i = 0;i < CONTEXT_WINDOW_BPL;i++)
      saved[i] = 0;

   /* Initialise context information array */
  
   for (i = 0;i < NUM_CONTEXTS;i++)
   {
      contexts[i].zero_count = 1;
      contexts[i].sum = 2;   /* No explicit count of ones is kept */      
   }			     /* as this is implicit in the sum	  */
}

/************************************************************************
 
   Function   : Decompress
   Parameters : None
   Returns    : Nothing
   
   Decompress decompresses a fax file read in from std input.
   
 ***********************************************************************/
 
void decompress()
{
   register codevalue	S_low=0, S_high=0;
 		    /* Arithmetic decoder vars high and low of range */
   register int 
      context,      /* Context at predicted bit */
      bitnum,       /* Bit being compressed on current line */
      S_bitstogo,   /* Arithmetic decoder var - used in inputting bits */
      H = half,     /* Arithmetic decoder var - contains constant half */
      last,         /* Shifting three bit field of last three bits read in */
      bitsleft = 8, /* Mask for getting bit out of byte */
      byte = 0;     /* Byte read in from  */

   startinputingbits();
   startdecoding();

   for (line = 0;line < NUM_LINES;line++)
   {
      last = 0;   /* Clear shifting temporary storage for incoming bits */

    /* Start iterating over bits in line - start in from edge of 'sheet'
       to give white space at edge for context */

      for (bitnum = CONTEXT_SIDE_BITS;
           bitnum < (CONTEXT_SIDE_BITS + BITS_PER_LINE);bitnum++)
      {

   /* Work out context that precedes bit being predicted */

         context = saved[bitnum] | (last >> 3);

    /* Store that part of the context that will be used on the next line */ 
 
         saved[bitnum] = (context & CONTEXT_MASK) << 6;
    
    /* Decode the bit currently being decompressed and update the model */
    /* Call arithmetic_decode_target to get position in range */
        
         if (arithmetic_decode_target(contexts[context].sum) 
               < contexts[context].zero_count)
         {  
            /* Decode a zero bit */
            arithmetic_decode_zero(contexts[context].zero_count,
                                   contexts[context].sum);
                                   
            contexts[context].zero_count++; /* Increment zero bit count */
            write_decoded0;                 /* Output a decoded zero */

       /* Add a zero bit to shifting storage and add this to previously
          stored context from two bits back */
           
            saved[bitnum-2] |= (last = (last << 1) & 0x38);            
         }
         else
         {
            /* 'Decode' a one bit */
            arithmetic_decode_one(contexts[context].zero_count,
                                  contexts[context].sum);
                                  
            write_decoded1; /* Write out a decoded ont bit */

       /* Add a zero bit to shifting storage and add this to previously
          stored context from two bits back */
 
            saved[bitnum-2] |= (last = ((last << 1) | 0x8) & 0x38);
         }                                                         

       /* Increment sum count and check to see if counts need halving */
       
         if ((++contexts[context].sum) == HALVE_LIMIT)  
         {
            contexts[context].zero_count = (contexts[context].zero_count >> 2) + 1;
            contexts[context].sum = (contexts[context].sum >> 2) + 2;
         }
      }
   }
}

/*************************************************************************

                                 Main program.
   
 ************************************************************************/
 
main(argc,argv)
int argc;
char **argv;
{
   initialise_model();
   fprintf(stderr,"Decompressing file, please wait.\n");
   start_time = get_time();              /* Get starting time */
   decompress();			 
   total_time = get_time() - start_time; /* Get total time from difference */  
   fprintf(stderr,"%s: Decompressed fax in %.3f seconds.\n",argv[0],total_time);
   exit(0);
}
