/*
            WINDOW.H            The declarations of user window routines
                                in WINDOW.LIB. These routines are written
                                in C, and call on routines from the library
                                VIDEO.LIB (defined in VIDEO.H).  The video
                                library MUST be included in the list of
                                libraries in the project file, otherwise
                                TURBO C won't find the routines, and your
                                compile will fail.

            (c) copyright 1987  by  Timothy Legant
*/

#define MAXWINDOWS  16
#define FRAMESTYLES  3
#define FRAMEPIECES  7


typedef struct {
  unsigned char   x1,y1,x2,y2;
  unsigned char   xpos,ypos;
  unsigned char   numcols,numrows;
  int             winsize;
  unsigned char   frameforecol;
  unsigned char   framebackcol;
  unsigned char   winforecol;
  unsigned char   winbackcol;
  unsigned char   framestyle;
  unsigned int   *oldwin;
  } wcb;  /* window control block */

typedef wcb  *wcbptr;

int               delaywin;
int               activewin;
extern wcbptr     winstk[MAXWINDOWS];

void  extern cdecl initwin(void);
int   extern cdecl mkwindow(int,int,int,int,int,int,int,int,int,int);
void  extern cdecl rmwindow(void);
