/*
        VIDEO.H       A header file for the VIDEO.LIB library.  This
                      header file guarantees that the functions in the
                      library are declared properly and should ALWAYS be
                      used.

                      Use   #include <video.h>

        copyright (c) 1987 Timothy Legant
*/

typedef enum {black, blue, green, cyan, red, magenta, brown, lightgray,
              darkgray, lightblue, lightgreen, lightcyan, lightred,
              lightmagenta, yellow, white} tc_colors;

unsigned char     w_x1 =  0;              /*  the current window left side  */
unsigned char     w_y1 =  0;               /*  the current window top side  */
unsigned char     w_x2 = 79;             /*  the current window right side  */
unsigned char     w_y2 = 24;            /*  the current window bottom side  */
unsigned char     current_color = 0x07;       /*  the current window color  */

unsigned char     retrace_mode;   /*  check screen snow -  0 = no, 1 = yes  */
unsigned char     EGA;              /*  0 = EGA not active, 1 = EGA active  */
unsigned char     vid_mode;                     /*  the current video mode  */

void far *vid_addr;                    /*  the segment of the video screen  */


void extern cdecl initvid(void);
void extern cdecl qputch(int ch,int len);
void extern cdecl qputs(char *str);
void extern cdecl qputxy(int x,int y,char *str);
void extern cdecl qputa(int attr,int len);
void extern cdecl color(int fore,int back);
void extern cdecl vidoff(void);              /* blanks screen on CGA or MDA */
void extern cdecl vidon(void);             /* unblanks screen on CGA or MDA */
int  extern cdecl window(int x1,int y1,int x2,int y2);
void extern cdecl clrwin(void);
void extern cdecl insline(void);
void extern cdecl delline(void);
void extern cdecl gotoxy(int x,int y);
int  extern cdecl wherex(void);
int  extern cdecl wherey(void);
void extern cdecl clreol();
int  extern cdecl getpage();
void extern cdecl setpage(int vidpage);
void extern cdecl getcursor(int *startline,int *stopline);
void extern cdecl setcursor(int startline,int stopline);
void extern cdecl savewin(unsigned *anyarray);
void extern cdecl restorewin(unsigned *anyarray);

#define forecolor(fore)  color((fore),(current_color >> 4))
#define backcolor(back)  color((current_color & 0x0F),(back))
