/* famous_quotes.c                                                            */
/*                                                                            */
/* Program to output random quotes from input file. Written in  BORLAND's     */
/* Turbo C                                                                    */
/*                                                                            */
/* Copyright 1988 by Pat Klaus                                                */
/*                   2751 Prosperity Ave.                                     */
/*                   Fairfax, Va. 22031                                       */
/*                   (703) 876 - 8070                                         */
/*                                                                            */
/* You are FREE to use this program for your personal enjoyment. You may not  */
/* use this program in a commercial manner without my written permission. For */
/* personal use, NO PAYMENT is asked or expected. If you get some use or      */
/* enjoyment from this program and want to render payment, then do something  */
/* good for someone else in turn.                                             */
/*                                                                            */
/* Inputs : Source file of quotes                                             */
/*          Index file for quotes, as output from makeidx.c                   */
/*                                                                            */
/*  To use this program, just enter famous, followed by the file name of the  */
/*  input quote data, followed by the file name of the index file for the     */
/*  quote data. If you create your own quote file, or edit the quote file,    */
/*  run MAKEINDX to create an index for the new quote file that you have      */
/*  either created or edited.                                                 */
/*                                                                            */
/* Usage : famous "input file and path for quote source" "input file and path */
/*                                                         for index file"    */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys\stat.h>
#include <conio.h>                     /* for  color and direct screen io */
#define EQUIPLIST 0x410                /* location of equipment list word */

main( int argc,  char *argv[] )
{
FILE *infile, *index ;                 /* pointers to input, output files */
char ch ;
long timenow ;
long random_offset, random_index ;
unsigned long quote_offset ;
int  number_indexes_in_file, i;
int  xstat = 0 ;                       /* just to satisfy TC */
int  quote_number, quote_str_len ;
struct stat index_fileinfo ;
struct text_info screeninfo ;
int  far *farptr ;
unsigned int equip;
int vidmode  ;
char savemode, saveattr ;

gettextinfo(&screeninfo) ;         /* get the current screen info */
savemode = screeninfo.currmode ;
saveattr = screeninfo.attribute ;
farptr = (int far *) EQUIPLIST;
equip = *(farptr) ;
vidmode = (equip >> 4) & 3 ;         /* test for initial video mode */
if(vidmode < 3 ) textmode(C80) ;      /* if not mono, then set text C80 */
if ( argc <= 2 )
 {
 printf("\nI'm sorry, but I can't run famous for you until you tell me where\n ");
 printf( " to find my input source file of quotes and indexes \n " );
 printf(" \n  For example, \n\n famous   [\\path\\]fquote1.dat");
 printf("   [\\path\\]fquote1.idx\n\n");
 printf(" \n Copyright 1988 by Pat Klaus \n" );
 printf("                    2751 Prosperity Ave. \n") ;
 printf("                    Fairfax, Va. 22031 \n") ;
 printf("                    (703) 876 - 8070  \n") ;
 exit(xstat);
 }
if( (infile = fopen( argv[1], "r") ) == NULL )  /* open source file of quotes */
   {printf("Can't open quote source file %s . \n",argv[1] ); exit(xstat); }
if( (index = fopen( argv[2], "rb") ) == NULL )
   {printf("Can't open quote index file %s . \n",argv[2] ); exit(xstat); }

  /* find out the number of quotes in the source file (= to # of indexes) */
 stat( argv[2], &index_fileinfo ) ;    /* returns file size in bytes */
 number_indexes_in_file = index_fileinfo.st_size / sizeof(random_index) ;

 srand( time(&timenow) % 1000000  );     /* start at a random place */

		  /* now pick a random index by generating a random offset */
 random_offset = sizeof(random_index) * (rand() % (number_indexes_in_file + 1)) ;

			     /* try to move the file pointer to there */
 if ( fseek(index, random_offset, 0) != 0 )
   {printf("Error in fseek. Suspect bad index file."); exit(xstat) ; }

		  /* Read the offset of the random quote in the quote file */
 fread(&quote_offset, sizeof(quote_offset),1,index);

			     /* try to move the file pointer to there */
 if ( fseek(infile, quote_offset, 0) != 0 )
   {printf("Error in fseek. Bad quote source file"); exit(xstat) ; }

			 /* read the quote number and quote string length */
 fscanf(infile, "%d %d ",&quote_number, &quote_str_len);

 directvideo = 0 ;         /* Hey, I know that the book says this should  */
			   /* be 1 for faster writes, but on my machines, */
			   /* for this program, 0 works better!!          */
 textbackground(BLUE) ;       /* my choice color */
 textcolor(CYAN);             /* also nice */
 for (i = 0 ; i <80 ; i++)
  putch(0xDC) ;                 /* draw a half bar across the screen */
 clreol();
 putch('\n');
 putch(' ');                              /* format */
 textcolor( WHITE ) ;
 for ( i=0 ; i < quote_str_len ; i++ )
    {
     ch = getc(infile);                 /* output the quote */
     if ( ch == '\n') clreol();
     putch(ch);
    }
 clreol();
 putch('\n');
 textcolor(CYAN);
 for (i = 0 ; i <80 ; i++)
    putch(0xDC) ;                /* draw a half bar across the screen */
 textmode(savemode) ;            /* set the screen back to it's */
 textattr(saveattr  ) ;          /* previous state              */
 clreol();
}

