/* makeindx.c                                                                 */
/*                                                                            */
/* Copyright 1988 by Pat Klaus                                                */
/*                   2751 Prosperity Ave.                                     */
/*                   Fairfax, Va. 22031                                       */
/*                   (703) 876 - 8070                                         */
/*                                                                            */
/* Program to create index file for quote data. Written in  BORLAND's         */
/* Turbo C                                                                    */
/*                                                                            */
/* You are free to use this program for your personal enjoyment. You may not  */
/* use this program in a commercial manner without my written permission. For */
/* personal use, NO PAYMENT is asked or expected. If you get some use or      */
/* enjoyment from this program and want to render payment, then do something  */
/* good for someone else in turn.                                             */
/*                                                                            */
/* Inputs : Source file of properly formated quote data                       */
/* Output : Index for the source file of quotes                               */
/*                                                                            */
/* To use this program, just enter makeindx, followed by the file name that   */
/* has the source file of input quotes, followed by output file name for the  */
/* index file.                                                                */
/*                                                                            */
/* Usage : makeindx Input_File_Name_For_Quote_Data Output_File_Name_For_Index */
/*                                                                            */
/* This program takes the input quote data file, and                          */
/* creates an index file that contains the relative offsets of the quotes.    */
/* The output of this program (the created index file), along with the        */
/* quote data file, is used as input to quote.c .                             */

#include <stdio.h>
#include <stddef.h>
#include <ctype.h>
#include <string.h>

main( int argc,  char *argv[] )
{
int   nquote,  sl ;
FILE *infile, *ptr_output ;
char one_line_in[120]; 
long quote_offset ;

if ( argc <= 2 )
 {
    printf(" Usage: makeindx \"input file spec\"  \"output file spec\"");
    exit();
 }

if( (infile = fopen( argv[1], "r") ) == NULL )   /* open file to convert */
   {printf("Can't open file %s for conversion. \n",argv[1] ); exit(); }

		    /* open index file for output */
if( (ptr_output = fopen( argv[2], "wb") ) == NULL )  
   {printf("Can't open file %s for output. \n", argv[2] ); exit(); }

 nquote = 0 ;
 while( fgets ( one_line_in, 119, infile) != NULL)
   {
    sl = strlen( one_line_in ) ;
    if ( isdigit(one_line_in[0]) && ( sl <= 12 ) )   
      {
	quote_offset = ftell(infile) - sl  ;
        fwrite(&quote_offset, sizeof(quote_offset), 1, ptr_output);
	nquote += 1 ;             /* count the quotes */
      }
   }
    printf("\nTotal number of quotes indexed = %d \n", nquote);
    close( ptr_output ) ;
    close(infile);
}
   
