/************************************************************************
**
** @(#)tvscreen.cpp	08/13/93	Chris Ahlstrom
**
**	Uses TurboVision TTerminal class to implement a replacement for
** printf() routines.
**
**	The callers of printf() can instead format their strings first,
** then call screenmsg() to write text to a dumb terminal, where it
** collects so that the user can scroll through it and not miss any
** messages from subroutines.
**
**	I tried to do this myself in tvwindow.cpp, but later saw that
** TV already had there own (and better) version.
**
*************************************************************************/

#define TVSCREEN_cpp

#include <stdio.h>
#include <string.h>
#include <io.h>
#include <alloc.h>
#include <fcntl.h>
#include <strstrea.h>
#include <fstream.h>

#include "tvscreen.h"			/* CPP routines for TEST code	*/


/************************************************************************
** TWindowScreen constructor and desctructor
**
**	We could override TWindow::initFrame() for a fancier frame.
**
*************************************************************************/

TWindowScreen::TWindowScreen
(
    const TRect& bounds,	// initial size rectangle for window
    const char *atitle,		// title for the top of the frame
    short anumber,		// bogus number for the window (wmNoNumber)
    ushort bufsize		// buffer size for window
)
  :
    TWindowInit	(TWindowScreen::initFrame),
    TWindow	(bounds, atitle, anumber)
{
    screenInterior = makeInterior(bounds, bufsize);
    if (screenInterior)
	insert(screenInterior);
}


TWindowScreen::~TWindowScreen()
{
//    if (screenInterior)       	// might be deleted by the desktop
//    	delete screenInterior;
}


/************************************************************************
** TWindowScreen::makeInterior()
*************************************************************************/


TTerminal *
TWindowScreen::makeInterior
(
    TRect bounds,
    ushort bufsize
)
{
    bounds = getExtent();		// size of the window
    bounds.grow(-1, -1);		// interior size matches window
    return new TTerminal
    (
	bounds,
        0,				// no horizontal scrollbar
        standardScrollBar(sbVertical | sbHandleKeyboard),
        bufsize
    );
};


/************************************************************************
** Friend functions of TWindowScreen class
*************************************************************************/

#define LEFT_X	 1
#define LEFT_Y	 5
#define RIGHT_X	78
#define RIGHT_Y	22

TWindowScreen *
startWindowScreen
(
    TDeskTop *desktop,
    unsigned buffsize
)
{
    char title[64];				// must match sprintf() string

    if ((coreleft() - 1024) < buffsize)
        buffsize = unsigned(coreleft() - 1024);

    TWindowScreen *crt = new TWindowScreen
    (
	TRect(LEFT_X, LEFT_Y, RIGHT_X, RIGHT_Y),
	"Subroutine Messages",
	wnNoNumber,
	buffsize
    );
    desktop->insert(crt);

    /*
    ** Assign the TTerminal interior text device driver to a text "file"
    */

    otstream os(crt->screenInterior);		// open an output text stream

    // crt->screenOStream = &os;		// save handle to it

    sprintf(title, "TTERMINAL CONSOLE WINDOW, %u bytes\n\n\0", buffsize);
    doScreenMessage(crt, title);		// sort of a sanity check
    crt->screenInterior->scrollTo(0, 0);	// show top of the buffer

    return crt;					// return the handle
}


/************************************************************************
** doScreenMessage()
**
**	This TWindowClass friend simply writes the message to the
** window's stream, then flushes the buffer so the message appears
** right away.
**
**	For some reason, cannot pass the pointer "screenOStream" without
** causing weird problems (see the unuseable code in the USEABLE_CODE
** #if below).
**
*************************************************************************/

void
doScreenMessage
(
    TWindowScreen *handle,
    char *message
)
{
    otstream os(handle->screenInterior);
    int length = strlen(message);

    if
    (
	(handle != (TWindowScreen *) 0)  && (message != NULL) &&
	handle->screenInterior->canInsert(length)
    )
        os << message << flush;
};


#if defined(USEABLE_CODE)				// { USEABLE_CODE

void
doScreenMessage
(
    TWindowScreen *handle,
    char *message
)
{
    if
    (
	(handle != (TWindowScreen *) 0)  &&
	(message != NULL) &&
	handle->screenInterior->canInsert(strlen(message))
    )
        *handle->screenOStream << message << flush;
};

#endif							// } USEABLE_CODE
