/************************************************************************
**
** @(#)tinput.h		06/08/93	Chris Ahlstrom
**
** C++
**
**	Contains, at present, an interface to the menu fields.
** Added support for byte-sized radio-buttons and check-boxes.
**
*************************************************************************/

#if !defined(TINPUT_h)					// { TINPUT_h
#define TINPUT_h

#if !defined(Uses_TInputLine)			// { Uses_TInputLine
#define Uses_MsgBox
#define Uses_TCheckBoxes
#define Uses_TCluster
#define Uses_TEvent
#define Uses_TInputLine
#define Uses_TKeys
#define Uses_TRadioButtons
#define Uses_TRect
#define Uses_TStreamable
#define Uses_TStreamableClass
#include <tv.h>					// Turbo Vision declarations
#endif						// } Uses_TInputLine

#if !defined(__STDIO_H)
#include <stdio.h>				// sprintf() only
#endif

#if !defined(__STDLIB_H)
#include <stdlib.h>				// data conversion functions
#endif

#if !defined(__STRING_H)
#include <string.h>				// string manipulations
#endif

#if !defined(__STRSTREAM_H)
#include <strstream.h>				// stream functions
#endif

#include "tinpextd.h"				// TExtended class declaration
#include "tv_menu.h"				// for Range declaration


/***********************************************************************
** Inheritance from TInputLine
**
**	TInputLine is a Turbo Vision class provided by Borland.
** We use it unaltered here for conventional NULL-terminated ASCII
** strings.
**
**	We don't need to define a new class for strings (lines), but
** we do need to specify our maximum buffer size.
**
************************************************************************/

#define linBufSize	128	// maximum number of characters allowed
#define linDatSize	 20	// default databox size


/***********************************************************************
** TByteString
**
**	This class is a minor extension of TInputLine designed to
** handle strings of bytes that have no NULL terminator.
**
************************************************************************/

class TByteString : public TInputLine
{

public:

    TByteString
    (
	const TRect& bounds,
	int aMaxLen
    );

    virtual ushort dataSize();
    virtual void getData( void *rec );
    virtual void setData( void *rec );

protected:

    TByteString( StreamableInit ) : TInputLine( streamableInit ) {};

private:

    virtual const char *streamableName() const
    {
	return name;
    }

public:

    static const char * const name;
    static TStreamable *build();

};
#define bstrBufSize	128	// maximum number of characters allowed
#define bstrDatSize	 20	// default databox size

inline ipstream& operator >> ( ipstream& is, TByteString& cl )
{
    return is >> (TStreamable&)cl;
}

inline ipstream& operator >> ( ipstream& is, TByteString*& cl )
{
    return is >> (void *&)cl;
}

inline opstream& operator << ( opstream& os, TByteString& cl )
{
    return os << (TStreamable&)cl;
}

inline opstream& operator << ( opstream& os, TByteString* cl )
{
    return os << (TStreamable *)cl;
}


/***********************************************************************
** TInputByte
************************************************************************/

class TInputByte : public TExtended
{

public:

    TInputByte
    (
	const TRect& bounds,
	int aMaxLen,
	const Range& code,
	char *formatstring,
	int mapped,
	const Range& user
    );
    // ~TInputByte();

    virtual ushort dataSize();
    virtual void getData( void *rec );
    virtual void setData( void *rec );
    virtual Boolean valid( ushort command );
    virtual double getValue();		// get current value (byte, long...)
    virtual void putValue(double);	// put current value back
    virtual void updateValue();		// redisplay current value

    unsigned char Value;		// current value of the Byte
    char *format;			// pointer to desired Byte format

protected:

    TInputByte(StreamableInit) : TExtended(streamableInit) {};
    virtual void write( opstream& );
    virtual void *read( ipstream& );

private:

    virtual const char *streamableName() const
    {
	return name;
    }

public:

    static const char * const name;
    static TStreamable *build();

};
#define byteBufSize	8		// maximum number of characters allowed
#define byteDatSize	6		// default databox size

inline ipstream& operator >> ( ipstream& is, TInputByte& cl )
{
    return is >> (TStreamable&)cl;
}

inline ipstream& operator >> ( ipstream& is, TInputByte*& cl )
{
    return is >> (void *&)cl;
}

inline opstream& operator << ( opstream& os, TInputByte& cl )
{
    return os << (TStreamable&)cl;
}

inline opstream& operator << ( opstream& os, TInputByte* cl )
{
    return os << (TStreamable *)cl;
}


/***********************************************************************
** TInputSignedByte
************************************************************************/

class TInputSignedByte : public TInputByte
{

public:

    TInputSignedByte
    (
	const TRect& bounds,
	int aMaxLen,
	const Range& code,
	char *formatstring,
	int mapped,
	const Range& user
    );
    // ~TInputSignedByte();

    virtual void getData( void *rec );
    virtual void setData( void *rec );
    virtual double getValue();		// get current value (byte, long...)
    virtual void putValue(double);	// put current value back
    virtual void updateValue();		// redisplay current value

    signed char Value;			// current value of the Byte
    char *format;			// pointer to desired Byte format

protected:

    TInputSignedByte(StreamableInit) : TInputByte(streamableInit) {};

private:

    virtual const char *streamableName() const
    {
	return name;
    }

public:

    static const char * const name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TInputSignedByte& cl )
{
    return is >> (TStreamable&)cl;
}

inline ipstream& operator >> ( ipstream& is, TInputSignedByte*& cl )
{
    return is >> (void *&)cl;
}

inline opstream& operator << ( opstream& os, TInputSignedByte& cl )
{
    return os << (TStreamable&)cl;
}

inline opstream& operator << ( opstream& os, TInputSignedByte* cl )
{
    return os << (TStreamable *)cl;
}


/***********************************************************************
** TInputInteger
************************************************************************/

class TInputInteger : public TExtended
{

public:

    TInputInteger
    (
	const TRect& bounds,
	int aMaxLen,
	const Range& code,
	char *formatstring,
	int mapped,
	const Range& user
    );
    // ~TInputInteger();

    virtual ushort dataSize();
    virtual void getData( void *rec );
    virtual void setData( void *rec );
    virtual Boolean valid( ushort command );
    virtual double getValue();		// get current value (byte, long...)
    virtual void putValue(double);	// put current value back
    virtual void updateValue();		// redisplay current value

    int Value;				// current value of the integer
    char *format;			// pointer to desired integer format

protected:

    TInputInteger( StreamableInit ) : TExtended( streamableInit ) {};
    virtual void write( opstream& );
    virtual void *read( ipstream& );

private:

    virtual const char *streamableName() const
    {
	return name;
    }

public:

    static const char * const name;
    static TStreamable *build();

};
#define intBufSize	18		// maximum number of characters allowed
#define intDatSize	 6		// default databox size

inline ipstream& operator >> ( ipstream& is, TInputInteger& cl )
{
    return is >> (TStreamable&)cl;
}

inline ipstream& operator >> ( ipstream& is, TInputInteger*& cl )
{
    return is >> (void *&)cl;
}

inline opstream& operator << ( opstream& os, TInputInteger& cl )
{
    return os << (TStreamable&)cl;
}

inline opstream& operator << ( opstream& os, TInputInteger* cl )
{
    return os << (TStreamable *)cl;
}


/***********************************************************************
** TInputFloat
************************************************************************/

class TInputFloat : public TExtended
{

public:

    TInputFloat
    (
	const TRect& bounds,
	int aMaxLen,
	const Range& code,
	char *formatstring,
	int mapped,
	const Range& user
    );
    // ~TInputFloat();

    virtual ushort dataSize();
    virtual void getData( void *rec );
    virtual void setData( void *rec );
    virtual Boolean valid( ushort command );
    virtual double getValue();		// get current value (byte, long...)
    virtual void putValue(double);	// put current value back
    virtual void updateValue();		// redisplay current value

    double Value;			// current value of the float
    char *format;			// pointer to floating-point format

protected:

    TInputFloat( StreamableInit ) : TExtended( streamableInit ) {};
    virtual void write( opstream& );
    virtual void *read( ipstream& );

private:

    virtual const char *streamableName() const
    {
	return name;
    }

public:

    static const char * const name;
    static TStreamable *build();

};
#define floatBufSize	24		// maximum number of characters allowed
#define floatDatSize	 8		// default databox size

#ifdef DOUBLE_CRAP
inline ipstream& operator >> ( ipstream& is, TInputFloat& cl )
{
    return is >> (TStreamable&)cl;
}

inline ipstream& operator >> ( ipstream& is, TInputFloat*& cl )
{
    return is >> (void *&)cl;
}

inline opstream& operator << ( opstream& os, TInputFloat& cl )
{
    return os << (TStreamable&)cl;
}

inline opstream& operator << ( opstream& os, TInputFloat* cl )
{
    return os << (TStreamable *)cl;
}
#endif


/***********************************************************************
** TInputLong
************************************************************************/

class TInputLong : public TExtended
{

public:

    TInputLong
    (
	const TRect& bounds,
	int aMaxLen,
	const Range& code,
	char *formatstring,
	int mapped,
	const Range& user
    );
    virtual ushort dataSize();
    virtual void getData( void *);
    virtual void setData( void *);
    virtual Boolean valid( ushort );
    virtual double getValue();		// get current value (byte, long...)
    virtual void putValue(double);	// put current value back
    virtual void updateValue();		// redisplay current value

    long Value;				// current value of the integer
    char *format;			// pointer to desired integer format

protected:

    TInputLong( StreamableInit ) : TExtended( streamableInit ) {};
    virtual void write( opstream& );
    virtual void *read( ipstream& );

private:

    virtual const char *streamableName() const
    {
	return name;
    }

public:

    static const char * const name;
    static TStreamable *build();

};
#define longBufSize	24		// maximum number of characters allowed
#define longDatSize	10		// default databox size

inline ipstream& operator >> ( ipstream& is, TInputLong& cl )
{
    return is >> (TStreamable&)cl;
}

inline ipstream& operator >> ( ipstream& is, TInputLong*& cl )
{
    return is >> (void *&)cl;
}

inline opstream& operator << ( opstream& os, TInputLong& cl )
{
    return os << (TStreamable&)cl;
}

inline opstream& operator << ( opstream& os, TInputLong* cl )
{
    return os << (TStreamable *)cl;
}


/***********************************************************************
** TByteRadioButtons
************************************************************************/

class TByteRadioButtons : public TRadioButtons
{

public:

    TByteRadioButtons(const TRect& bounds, TSItem *aStrings);

    virtual ushort dataSize();
    virtual void getData(void *rec);
    virtual void setData(void *rec);
    virtual Boolean mark( int item );
    virtual void movedTo( int item );
    virtual void press( int item );

    static const char * const name;
    static TStreamable *build();
    // virtual TStreamable *build();

protected:

    unsigned char bytevalue;
//    virtual void write( opstream& );
//    virtual void *read( ipstream& );
    TByteRadioButtons(StreamableInit) : TRadioButtons(streamableInit)
    { };

};

inline ipstream& operator >> ( ipstream& is, TByteRadioButtons& cl )
{
    return is >> (TStreamable&)cl;
}

inline ipstream& operator >> ( ipstream& is, TByteRadioButtons*& cl )
{
    return is >> (void *&)cl;
}

inline opstream& operator << ( opstream& os, TByteRadioButtons& cl )
{
    return os << (TStreamable&)cl;
}

inline opstream& operator << ( opstream& os, TByteRadioButtons* cl )
{
    return os << (TStreamable *)cl;
}

inline TByteRadioButtons::TByteRadioButtons
(
    const TRect& bounds,
    TSItem *aStrings
)
    : TRadioButtons(bounds, aStrings)
{
}


/***********************************************************************
** TByteCheckBoxes
************************************************************************/

class TByteCheckBoxes : public TCheckBoxes
{

public:

    TByteCheckBoxes(const TRect& bounds, TSItem *aStrings);

    virtual ushort dataSize();
    virtual void getData(void *rec);
    virtual void setData(void *rec);
    virtual Boolean mark( int item );
    virtual void press( int item );

    static const char * const name;
    static TStreamable *build();
    // virtual TStreamable *build();

protected:

    unsigned char bytevalue;
//    virtual void write( opstream& );
//    virtual void *read( ipstream& );
    TByteCheckBoxes(StreamableInit) : TCheckBoxes(streamableInit)
    { };

};

inline ipstream& operator >> ( ipstream& is, TByteCheckBoxes& cl )
{
    return is >> (TStreamable&)cl;
}

inline ipstream& operator >> ( ipstream& is, TByteCheckBoxes*& cl )
{
    return is >> (void *&)cl;
}

inline opstream& operator << ( opstream& os, TByteCheckBoxes& cl )
{
    return os << (TStreamable&)cl;
}

inline opstream& operator << ( opstream& os, TByteCheckBoxes* cl )
{
    return os << (TStreamable *)cl;
}

inline TByteCheckBoxes::TByteCheckBoxes
(
    const TRect& bounds,
    TSItem *aStrings
)
    : TCheckBoxes(bounds, aStrings)
{
}



#endif							// } TINPUT_h

