/************************************************************************
**
** @(#)screnmsg.h	08/12/93	Chris Ahlstrom
**
**	An interface between C and C++ (in the guise of Turbo Vision).
**
*************************************************************************/

#ifndef SCRENMSG_h					/* { SCRENMSG_h	*/
#define SCRENMSG_h


/************************************************************************
** C/C++ screenmsg() function
**
**	This header file supports two versions of the same function...
** a name-mangled C++ version, and a non-name mangled C version.
** Since the selection must be made at compile and link time,
** we must define this function as a macro.
**
**	Primitive C callers will not need to know of the existence and
** usage of Turbo Vision.  I swear it.
**
** Format:
**
**   int screenmsg(a, b, c);
**
**    (a) int use_io		Whether to ignore output
**    (b) void *handle		Bogus for now
**    (c) char *string		String to display
**
**	This macro is defined in either tvscreen.h or cnscreen.h.
**
*************************************************************************/

#ifdef USE_TURBO_VISION			/* { USE_TURBO_VISION		*/

    #include "tvscreen.h"			/* Turbo Vision support	*/

#else					/* }{ USE_TURBO_VISION		*/

    #include "cnscreen.h"			/* console i/o support	*/

#endif					/* } USE_TURBO_VISION		*/


#endif							/* } SCRENMSG_h	*/
