/************************************************************************
**
** @(#)respvga.h	01/03/94	Chris Ahlstrom
**
**	A convenient, out-of-the-way place to define a simple
** version of the response-box lights.  The representation is
** very simple.  We define a virtual screen of 1000 in width,
** and a 1000 in height.  Then we locate the coordinates in
** terms of these maximal dimensions.  Basically, the numbers
** below respresent to coordinates in terms of percentage of
** full-screen, times 10.
**
**	Note that the virtualBox will be our standard, and we
** will use that for converting all other representations into
** the units proper for the display device.
**
**	Guide to conversions.  The "screen_" values are as per
** "screen.c" and "screen.h" in the AIR library.
**
**  1.  Converting virtual coordinates to characters:
**
**	a.  screen_x = (virtual_x / VIRTmax) * screen_columns
**	b.  screen_y = (virtual_y / VIRTmax) * screen_rows
**
**  2.  Converting virtual coordinates to pixels:
**
**	a.  screen_x = (virtual_x / VIRTmax) * screen_gmax_x
**	b.  screen_y = (virtual_y / VIRTmax) * screen_gmax_y
**	    
**  3.	Converting VGA pixel dimensions into EGA pixel dimensions:
**
**	a. X-values are such that EGA_X = VGA_X
**	b. Y-values are such that EGA_X = (3/4)VGA_X
**
*************************************************************************/


#if !defined(RESPVGA_h)					/* { RESPVGA_h	*/
#define RESPVGA_h

#include <graphics.h>

#include "respintr.h"		/* for ResponseBox declaration		*/

#define VIRTmax	1000		/* our standard (100 is too coarse)	*/


/************************************************************************
** Turbo Vision color support
**
**	Turbo Vision handles colors as object characteristics, rather
** than as attribute bytes.   You pick "the same color as normal window
** color", rather than the attribute "yellow on blue", for example.
** The main application defines a large palette that everything
** in Turbo Vision will use.  Each object defines a short array that
** contains indices into this large palette.
**
**	The programmer uses getColor to select an index into the
** local object's palette, and the local object's palette points
** to the large palette.
**
**	We set things up so that we can select either attribute bytes
** or TV palette indices at compile-time.
**
**	Further explanation of Turbo Vision palettes:
**
**	TApplication inherits cpColor (see APP.H) from TProgram, and
** I've decided (for now) to limit the choice of colors to this palette.
** See p. 342-3 of the TV manual for a list of the colors.  At present,
** we use only colors from one section (top of p. 343).  Also, we
** use the foreground colors (using character RCELL, which fills the
** whole foreground of the cell).  We could use RBACK (which doesn't
** fill the foreground with the background color.
**
**	None of the colors in cpColor has the bright red we desire
** for the READY_LIGHT.  Instead, yellow is used, which makes it
** at least a warning in American culture.
**
*************************************************************************/

#define RCELL	'\xDB'				/* gets foreground color*/
#define RBACK	' '				/* gets background color*/
#define TV_PALETTES	1

#if TV_PALETTES					/* { TV_PALETTES	*/

    #define RESPONSE_COLOR	 9
    #define INTERVAL_COLOR	10
    #define READY_COLOR		11
    #define ANSWER_COLOR	12
    #define BACKGROUND_COLOR	13

    #define RESPONSE_PAL	"\x21"		/* frame-active color	*/
    #define INTERVAL_PAL	"\x21"		/* frame-active color	*/
    #define READY_PAL		"\x28"		/* label-shortcut color	*/
    #define ANSWER_PAL		"\x22"		/* frame-icon color	*/
    #define BACK_PAL		"\x25"		/* static-text color	*/

#else						/* }{ TV_PALETTES	*/

    #define RESPONSE_COLOR	WHITE
    #define INTERVAL_COLOR	WHITE
    #define READY_COLOR		LIGHTRED
    #define ANSWER_COLOR	LIGHTGREEN
    #define BACKGROUND_COLOR	BROWN

#endif 						/* } TV_PALETTES	*/


#if defined(RESPWIND_cpp)			/* { RESPWIND_cpp	*/

#define LWDTH	266			/* width of response/interval	*/
#define LHGTH	200			/* height of response/interval	*/
#define FWDTH	 78			/* width of protocol lights	*/
#define FHGTH	 78			/* height of protocol lights	*/

#define LEFTX0	156			/* basic left X location	*/
#define LEFTX1	(LEFTX0 + LWDTH)
#define RGHTX0	578			/* basic right X location	*/
#define RGHTX1	(RGHTX0 + LWDTH)

#define INTVY0	334			/* basic Y location		*/
#define INTVY1	(INTVY0 + LHGTH)
#define RESPY0	(INTVY1 + LHGTH)	/* offset from interval light	*/
#define RESPY1	(RESPY0 + LHGTH)

#define READX0	 78			/* basic X for protocol lights	*/
#define READX1	(READX0 + FWDTH)
#define ANSWX0	844
#define ANSWX1	(ANSWX0 + FWDTH)

#define PROTY0	 78			/* basic Y for protocol lights	*/
#define PROTY1	(PROTY0 + FHGTH)

ResponseBox virtualBox =
{
    BACKGROUND_COLOR,			/* screen color		*/
    SOLID_FILL,				/* background fill style*/
    {					/* response_1		*/
	SOLID_FILL,
	RESPONSE_COLOR,
	LEFTX0, RESPY0, LEFTX1, RESPY1
    },
    {					/* response_2		*/
	SOLID_FILL,
	RESPONSE_COLOR,
	RGHTX0, RESPY0, RGHTX1, RESPY1
    },
    {					/* response_3		*/
	SOLID_FILL,
	RESPONSE_COLOR,
	0, 0, 0, 0			/* unused by default	*/
    },
    {					/* ready_light		*/
	SOLID_FILL,
	READY_COLOR,
	READX0, PROTY0, READX1, PROTY1
    },
    {					/* answer_light		*/
	SOLID_FILL,
	ANSWER_COLOR,
	ANSWX0, PROTY0, ANSWX1, PROTY1
    },
    {					/* interval_1		*/
	SOLID_FILL,
	INTERVAL_COLOR,
	LEFTX0, INTVY0, LEFTX1, INTVY1
    },
    {					/* interval_2		*/
	SOLID_FILL,
	INTERVAL_COLOR,
	RGHTX0, INTVY0, RGHTX1, INTVY1
    },
    {					/* interval_3		*/
	SOLID_FILL,
	INTERVAL_COLOR,
	0, 0, 0, 0			/* unused by default	*/
    },
    {					/* failure_light	*/
	SANS_SERIF_FONT,
	HORIZ_DIR,
	4,
	156, 750,
	"ERROR: please stop"
    }
};


#else						/* }{ RESPWIND_cpp	*/

extern ResponseBox virtualBox;

#endif						/* } RESPWIND_cpp	*/

#endif							/* } RESPVGA_h	*/
