/************************************************************************
**
** @(#)rbuttons.cpp	01/03/94	Chris Ahlstrom
**
**	This module interfaces C++ with code for handling various kinds
** of button devices.  This base class implements the keyboard
** buttons by default.
**
**	Also, until we decide that Koala support is really necessary,
** this class will take the place of any Koala device selection.
** Tentative support is given in korbutt.cpp/h.
**
**	See rbuttons.h to see what the keys mean.
**
*************************************************************************/

#define RBUTTONS_cpp

#include <conio.h>		// getch() function
#include <ctype.h>		// toupper() function

#include "rbuttons.h"		// ResponseButton class



/************************************************************************
** ResponseButton constructor and destructor
*************************************************************************/

ResponseButton::ResponseButton
(
    ResponseType buttondevice
)
  :
    responseDevice	(buttondevice),
    lastResponse	(NO_BUTTON)
{
}


ResponseButton::~ResponseButton ()
{
}


/************************************************************************
** readKey()
**
**	readKey() simply checks the device for a button-pressing
** status.  After the check, the routine immediately returns a status,
** with no waiting.
**
**	This default implementation supports input from the keyboard;
** the buttons (keys, here) to achieve each status are listed in
** square brackets.
**
** readkey() returns the following statuses (see the Response type in
** rbuttons.h):
**
**	0 if no button is pressed
**	1 if button 1 is pressed		[key '1']
**	2 if button 2 is pressed		[key '2']
**	3 if both buttons are pressed		[key 'b' or ESC]
**	4 if button 3 is pressed		[key '3']
**	7 if all three buttons were pressed.	[key 'a']
**
*************************************************************************/

int
ResponseButton::readKey ()
{
    int button = (int) NO_BUTTON;

    if (kbhit())
    {
	button = getch();
	if (button == KEY_BUTTON_1)
	    button = (int) BUTTON_1;
	else if (button == KEY_BUTTON_2)
	    button = (int) BUTTON_2;
	else if (button == KEY_BUTTON_3)
	    button = (int) BUTTON_3;
	else
	{
	    button = toupper(button);
	    if (button == KEY_BOTH_BUTTONS || button == KEY_BOTH_ESCAPE)
		button = (int) BOTH_BUTTONS;
	    else if (button == KEY_ALL_BUTTONS)
		button = (int) ALL_BUTTONS;
	}
    }
    lastResponse = (Response) button;
    return button;
}

/************************************************************************
** getLastResponse ()
**
**	This function returns the value of lastResponse.
** It is useful when the action to be caused by the response has to
** occur sometime after the response occurred.
**
*************************************************************************/

inline int
ResponseButton::getLastResponse ()
{
    return (int) lastResponse;
}


/************************************************************************
** waitKey()
**
**	Waits for a button to be pressed [repeatedly calls readKey()],
** and returns the value.
**
**	Returns same values as readKey(), except for NO_BUTTON.
**
**	At present, it looks like this routine does not need overriding.
**
*************************************************************************/

int
ResponseButton::waitKey ()
{
    int button;

    do
    {
	button = readKey();
	
    } while (button == (int) NO_BUTTON);

    return button;
}


/************************************************************************
** checkAbort()
**
**	Checks if both buttons (of the KeyResponse set) were pressed --
** if so, returns a non-zero value.
**
**	At present, it looks like this routine does not need overriding.
**
*************************************************************************/

int
ResponseButton::checkAbort ()
{
    int putzcounter;
    int chk = 0;

    for (putzcounter = 1; putzcounter <= 100; putzcounter++)
    {
	if (readKey() == BOTH_BUTTONS)
	{
	    chk = 1;
	    break;
	}
    }
    return chk;
}

