/************************************************************************
**
** @(#)msrbutt.cpp	01/05/94	Chris Ahlstrom
**
**	This module interfaces C++ with code for handling various kinds
** of button devices; the substrate is Borland's Turbo Vision.
**
*************************************************************************/

#define MSRBUTT_cpp

#include "msrbutt.h"		// MouseResponseButton class

extern "C"
{
    #include "tmouse.h"		// a few mouse routines [readMouseButtons()]
}



/************************************************************************
** MouseResponseButton constructor
*************************************************************************/

MouseResponseButton::MouseResponseButton ()
  :
    ResponseButton(MOUSE_RESPONSE)
{
}


MouseResponseButton::~MouseResponseButton ()
{
}


/************************************************************************
** readKey() override
**
**	Function to read the mouse buttons.
**
**	See the Response typedef in rbuttons.h.
**
*************************************************************************/

int
MouseResponseButton::readKey ()
{
    return (int) readMouseButtons();
}


/************************************************************************
** waitKey()
** checkAbort()
** getLastResponse()
**
**	These functions don't need overriding.
**
*************************************************************************/

