/************************************************************************
**
** @(#)mkbutton.cpp	01/05/94	Chris Ahlstrom
**
**	Creates the desired kind of button device.
**
*************************************************************************/

#define MKBUTTON_cpp

#include "mkbutton.h"		// ResponseButton class
#include "msrbutt.h"		// MouseResponseButton class
#include "korbutt.h"		// KoalaResponseButton class



ResponseButton *
makeResponseButton
(
    ResponseType buttontype
)
{
    ResponseButton *button;

    switch (buttontype)
    {
    case MOUSE_RESPONSE:

	button = new MouseResponseButton();
	break;

    case KEYBOARD_RESPONSE:

	button = new ResponseButton(buttontype);
	break;

    case KOALA_RESPONSE:

	button = new KoalaResponseButton();
	break;

    case MOUSE_POINT_RESPONSE:
    default:			// unsupported ResponseButton devices

	button = 0;
	break;
    }
    return button;
}
