/*
** @(#)math_aux.c	06/18/93	Chris Ahlstrom
**
**	Additional useful math routines.
*/

#include "math_aux.h"


/************************************************************************
** round
** iround
**
**	Takes a real number, and rounds it up to the next digit, then
** returns it as a long or an integer.
**
**	No error checking at all is done.  The commented-out version
** really screws up.
**
*************************************************************************/

long
round
(
    double x
)
{
    if (x > 0)
	x += 0.5;
    else if (x < 0)
	x -= 0.5;
    return((long) x);
}

int
iround
(
    double x
)
{
    if (x > 0.0)
	x += 0.5;
    else if (x < 0.0)
	x -= 0.5;
    return((int) x);
}

#ifdef BUGRIDDENCODE
long
round
(
    double x
)
{
    if (x > 0)
    {
	x += 0.5;
	if (x > (double) HUGE_LONG_INT)
	    x = 0.0;		/* to flag the overflow condition	*/
    }
    else
    {
	x -= 0.5;
	if (x < (double) LOW_LONG_INT)
	    x = 0.0;		/* to flag the underflow condition	*/
    }
    return((long) x);
}
#endif
