/************************************************************************
**
** @(#)grafxlog.h	01/05/94	Chris Ahlstrom
**
**	Contains routines for setting and obtaining the current video
** context in one fell swoop.  These routines obtain everything that
** Borland functions allow you to obtain concerning the graphics
** screen.
**
*************************************************************************/

#ifndef GRAFXLOG_h					/* { GRAFXLOG_h	*/
#define GRAFXLOG_h

#include "bios_vid.h"
#include "grafxscr.h"


extern int setGraphicsModes
(
    Screen *s
);
extern GraphicsDriver getGraphicsModes
(
    Screen *s
);
extern GraphicsDriver getScreenModes	/* Dell? getcolor() workaround	*/
(
    Screen *s
);
extern void getScreenVBS
(
    Screen *s
);
extern void showScreen
(
    Screen *s
);
extern int getvbs
(
    Video_BIOS_State *vbs
);
extern void getvbsdump (void);
extern void dumpvbs
(
    FILE *f,
    Video_BIOS_State *vbs
);
extern int getScreenContext
(
    Screen *s
);
extern int getgrafxmode (void);
extern int getgrafxpage (void);
extern int getgrafxcolumns (void);
extern int getgrafxcursorrow
(
    int page
);
extern int getgrafxcursorcolumn
(
    int page
);
extern int initGraphics
(
    Screen *s				/* all screen parameters	*/
);
extern void closeGraphics
(
    Screen *s				/* all screen parameters	*/
);



#endif							/* } GRAFXLOG_h	*/
