/************************************************************************
**
** @(#)filedlg.cpp	12/09/93	Chris Ahlstrom
**
**	C++
**
**	Displays selectable directories and files, and allows one
** of each to be picked or specified.
**
**	This code was shamelessly abstracted from the FVIEWER demo
** of Borland's Turbo Vision.  Inherit the wheel!  (Or, if you're
** tired of my verbose (over*blown*) commentary... "inherit the wind".)
** Be that as it may, I have significantly altered how this works.
**
*************************************************************************/

#define PROJECT "FACE_TV"	// string for the project
#define FILEDLG_cpp

#include <dir.h>
#include <dos.h>
#include <string.h>

#include "filedlg.h"


/************************************************************************
** FilePicker constructor
*************************************************************************/

FilePicker::FilePicker
(
    TDeskTop *desk,
    char *wildcard			// the starting wild-card
)
{
    desktop		= desk;
    nameActive		= FILE_INACTIVE;
    actionCode		= FILE_CANCELLED;

    if (wildcard != 0 && *wildcard != '\0')
	strcpy(wildCard, wildcard);
    else
	wildCard[0] = EOS;

    fpFileSpec[0]	= EOS;
    fpDrive[0]		= EOS;
    fpDirName[0]	= EOS;
    fpFileBase[0]	= EOS;
    fpFileExt[0]	= EOS;
    fpFileName[0]	= EOS;

    if (*wildCard != '*' && *wildCard != '?')
    {
	char *dest, *src, ch;
	int basecount = 8;		// DOS-dependent number
	int extcount = 3;		// DOS-dependent number

	nameActive = FILE_ACTIVE;
	dest = fpFileBase;
	src  = wildCard;

	while ((ch = *src++) != '.' && ch != '\0')
	{
	    if (basecount-- == 0)
		break;
	    *dest++ = ch;
	}
	*dest = '\0';

	if (ch == '.')
	{
	    dest = fpFileExt;
	    while ((ch = *src++) != '\0')
	    {
		if (extcount-- == 0)
		    break;
		*dest++ = ch;
	    }
	    *dest = '\0';
	}
	makeFileName(fpFileBase, fpFileExt);
    }
}



/************************************************************************
** FilePicker::pickFile
**
**	Allows subject to select a filename from the current directory,
** which must be set elsewhere.
**
**	Once selected, this complete file-specification (what Borland
** insists on calling "the path"), is broken up into it's components,
** which are saved in members of class FilePick.
**
**	A flag is also set, to indicate a good filename is now had.
**
** Returns (via members of FilePicker [see filedlg.h]):
**
**	actionCode	FILE_CANCELLED
**			FILE_PERFORM_ACTION
**
**	nameActive	FILE_INACTIVE
**			FILE_ACTIVE
**			FILE_SAME_STATUS
**
*************************************************************************/

void
FilePicker::pickFile
(
    char *wildcard,
    char *boxtitle,
    char *fieldtitle,
    ushort options
)
{
    FileActivity active	= FILE_INACTIVE;	// parameter to pass back
    FileAction action	= FILE_CANCELLED;	// parameter to pass back
    uchar historyid	= 100;			// OK, I guess...

    TFileDialog *d = new TFileDialog
    (
	wildcard, boxtitle, fieldtitle, options, historyid
    );
    if (d)
    {
	ushort control = desktop->execView(d);

	switch (control)
	{
	case cmFileOpen:	// update name, indicate it is active
	case cmOK:

	    d->getFileName(fpFileSpec);
	    fnsplit(fpFileSpec, fpDrive, fpDirName, fpFileBase, fpFileExt);
	    (void) strcpy(fpFileName, fpFileBase);
	    (void) strcat(fpFileName, fpFileExt);
	    active		= FILE_ACTIVE;
	    action		= FILE_PERFORM_ACTION;
	    break;

	case cmFileReplace:	// don't update name, it is still active

	    active		= FILE_ACTIVE;
	    action		= FILE_PERFORM_ACTION;
	    break;

	case cmFileClear:	// clear out the file name (inactivate it)

	    active		= FILE_INACTIVE;
	    action		= FILE_CANCELLED;
	    fpFileSpec[0]	= EOS;
	    fpDrive[0]		= EOS;
	    fpDirName[0]	= EOS;
	    fpFileBase[0]	= EOS;
	    fpFileExt[0]	= EOS;
	    fpFileName[0]	= EOS;
	    break;

	case cmCancel:		// no change in activity, but don't use name

	    active		= FILE_SAME_STATUS;
	    action		= FILE_CANCELLED;
	    break;
	}
	desktop->destroy(d);

	if (active != FILE_SAME_STATUS)	// cancelling preserves file activity
	    nameActive = active;

	actionCode = action;		// return what we need to do
    }
}

/************************************************************************
** FilePicker::chDir
**
*************************************************************************/

#define CHDIR_OPTIONS	(ushort) cdNormal
#define HISTORY_ID	(ushort) cmChangeDir

void
FilePicker::chDir()
{
    TView *d = new TChDirDialog(CHDIR_OPTIONS, HISTORY_ID);
    if (d)
    {
        desktop->execView(d);
	desktop->destroy(d);
    }
    getcwd(fpDirName, MAXDIR);
}


/************************************************************************
** FilePicker::fileDialog
**
**	Manages the FileDialog usage according to whether a filename
** is already active or not, and whether the file is to be read or
** written (mode != 0 means "to write");
**
*************************************************************************/

#define FPICK_OPTIONS	(fdClearButton | fdOKButton)
#define OVERWRITE(x)	((x) == FILE_CREATE || (x) == FILE_WRITE)

#define WF_SETUP_ALL_FILES	".*"	// this is one option
#define WF_SETUP_NO_EXTENSION	"."	// this is another option

char *
getextension
(
    char *filepath
)
{
    char *p;

    p = _fstrchr(filepath, '.');
    if (!p)
	return _fstrchr(filepath, '\0');
    else
	return p;
}


void
FilePicker::fileDialog
(
    FileOperation mode
)
{
    char *wildcard;
    char *title;
    char *label;
    ushort options	= FPICK_OPTIONS;

    actionCode = FILE_CANCELLED;		// default action
    if (nameActive == FILE_ACTIVE)		// got a filename to try?
    {
	if (fpFileName[0] != EOS)
	    wildcard = fpFileName;		// use extant name
	if					// desire to write this file?
	(
	    OVERWRITE(mode) && !findfirst(wildcard, &fileInfo, FA_NORMAL)
	)
	{
	    // options    |= fdReplaceButton;	// add "Replace" button
	    title	= "Overwrite File";
	    label	= "File to Replace (or new filename)";
	}
	else
	{
	    title	= "Read Last File";
	    label	= "File to Read";
	}
    }
    else					// got no filename already?
    {

	/****************************************************************
	** The following guarantees we have a wildcard, when the
	** previous name has been rendered inactive.
	*****************************************************************/

	char *tpath;
	char newwild[16];

	tpath = getextension(fpFileSpec);	// wildcard or full filespec
	strcpy(newwild, "*");
	if (*tpath == '.')			// was an extension found?
	    strcat(newwild, tpath);		// yes, add it
	else 
	    strcat(newwild, WF_SETUP_NO_EXTENSION); // no, hardwire an ext
	wildcard = newwild;

	if (OVERWRITE(mode))			// desire to write this file?
	{
	    title	= "Write New File";
	    label	= "File to Write";
	}
	else
	{
	    title	= "Read File";
	    label	= "File to Read";
	}
    }

    pickFile				// get nameActive and actionCode
    (
	wildcard,			// use given name as wildcard
	title,				// let title ask a question
	label,				// label for the name
	options				// button options for the box
    );
}


/************************************************************************
** fileActive()
** fileAction()
** inactivateFile()
** fileSpec()
** fileBase()
**
**	These three functions provide an non-changing interface between
** the outside world and the FilePicker members "actionCode",
** "fpFileSpec", and "fpFileBase".
**
**	fileBase copies fpFileBase[] into a string.
**
*************************************************************************/

FileAction
FilePicker::fileAction ()
{
    return actionCode;
}


FileActivity
FilePicker::fileActive ()
{
    return nameActive;
}


void
FilePicker::inactivateFile ()
{
    nameActive = FILE_INACTIVE;
}


char *
FilePicker::fileSpec ()
{
    if (nameActive == FILE_INACTIVE)
    {
	fileDialog(FILE_OPEN);		// generic, read or write
    }
    return &fpFileSpec[0];
}


int
FilePicker::fileBase
(
    char *destination
)
{
    int count;
    char ch;
    char *fp = fpFileBase;

    for (count = 0; count < MAXFILE; count++)
    {
	ch = *fp++;
	*destination++ = ch;
	if (ch == '\0')
	    break;
    }
    if (ch == '\0')			// don't count the null character
	count--;
    return count;
}


/************************************************************************
** FilePicker::makeFileName
**
**	Gets the current working directory, and appends the given
** filename to it.
**
**	Has the same result as FileDialog, but gets the name from
** DOS and a basename passed by the caller.  Also, not all the
** possible combinations of return values are employed.  However,
** it does separate out all the components.
**
**	Usually, we don't need all the components, but rather the
** whole filename, including the path, as stored in the field
** 
**			fpFileSpec[]
**
**	More on this later...
**
*************************************************************************/

void
FilePicker::makeFileName
(
    char *basename,
    char *extension
)
{
    FileActivity active	= FILE_INACTIVE;	// parameter to pass back
    FileAction action	= FILE_CANCELLED;	// parameter to pass back
    char *temp;
    
    temp = getcwd(fpFileSpec, MAXPATH);
    if (temp != NULL)
    {
	if (basename != NULL && basename[0] != EOS)
	{
	    strcat(temp, "\\");			// add the trailing slash
	    strcat(temp, basename);
	}
	if (extension != NULL && extension[0] != EOS)
	{
	    strcat(temp, ".");			// add the period
	    strcat(temp, extension);
	}
	(void) fnsplit				// get ALL the components
	(
	    fpFileSpec, fpDrive, fpDirName, fpFileBase, fpFileExt
	);
	(void) strcpy(fpFileName, fpFileBase);	// get the non-path part
	(void) strcat(fpFileName, fpFileExt);	// get the non-path part
	active		= FILE_ACTIVE;
	action		= FILE_PERFORM_ACTION;
    }
    else					// an error occurred
    {
	fpFileSpec[0]	= EOS;
	fpDrive[0]	= EOS;
	fpDirName[0]	= EOS;
	fpFileBase[0]	= EOS;
	fpFileExt[0]	= EOS;
	fpFileName[0]	= EOS;
	active		= FILE_INACTIVE;
	action		= FILE_CANCELLED;
    }
    nameActive = active;
    actionCode = action;		// return what we need to do
}
