/************************************************************************
**
** @(#)face_tv.h	01/05/94	Chris Ahlstrom
**
** C++
**
**	Contains, at present, an interface to the menu fields.
** This module is for the test program for the FACE_TV library.
**
*************************************************************************/


#if !defined(FACE_TV_h)					// { FACE_TV_h
#define FACE_TV_h

#include "filedlg.h"			// FilePicker declarations
#include "heapview.h"			// for testing of the heap
#include "dosshell.h"			// DOS-shell support
#include "menubars.h"			// supports menu-bar application
#include "tbox.h"			// support dialog-box application
#include "screnmsg.h"			// supports menu-bar application
#include "tv_confg.h"			// SimpleConfiguration class
#include "x_delay.h"			// DelayParameters class

extern int showFloatInBox
(
    double value
);


/************************************************************************
** TFaceApp
**
**	Obtains the menu/status bar initialization routines, the
** doDialog(), and shell() from the base objects.
** Note that TBox and DosShell could be considered "has-a" classes, and
** could be implemented as objects that are part of the TFaceApp class,
** instead of letting TFaceApp inherit from them.
**
**	But DosShell does have some private/protected members, so we'd
** need to use inheritance to get at its private members.  Anyway,
** I set it up this way before really knowing much about the concept
** of "has-a".
**
*************************************************************************/

class TFaceApp : public MenuBarApp, public TBox, private DosShell
{

public:

    TFaceApp();
    ~TFaceApp();

    virtual void handleEvent		// TV override
    (
	TEvent& event
    );
    void face_dialogs			// file dialogs
    (
	FileOperation rw,
	char *fname
    );
    virtual void idle();		// Updates heap view

    int respTest();			// ResponseDevice test
    int delayTest
    (
	DelayParameters *delays
    );

    UserMessages *msgArea;		// points to this class's errors
    ErrorCode appError;			// storage for the error code
    FilePicker *configFile;		// name of the configuration file
    TDialog *showBox;			// sample box for showing

protected:

    SimpleConfiguration *equipmentConfig;	// hard-wired list of equipment

private:

    TWindowScreen *testsWindow;
    void initTFaceApp();			// initial set-up
    int textMode;			// current (desired) text mode
    THeapView *heap;			// Heap view for debugging

};


#endif							// } FACE_TV_h

