/************************************************************************
**
** @(#)face_box.h	01/03/94	Chris Ahlstrom
**
**	C/C++ compatible.  Consists of three sections:
**
**	1.  The DAC (D/A converter) Parameters dialog box, stolen from
**	    the mod_dac modules of MODAPP, used here purely as a test
**	    bed for dialog box control.  This is a good test of the
**	    general data scheme.
**
**	2.  We also provide a section showing how to use the MappedField
**	    elements of tv_menu.h.  Here, the setup is a little more
**	    complex and indirect.
**
**	3.  The experimental parameters dialog box copped from the 
**	    mod_exp modules of MODAPP.  Just includes a few more type
**	    of data than item 1.
**
**	This header file describes sample data-structures that
** we can use with the dialog box code.  It illustrates the hard-wired
** DataTypes, byte-mapped data-types, and Extended data-types.
**
*************************************************************************/

#if !defined(FACE_BOX_h)				/* { FACE_BOX_h	*/
#define FACE_BOX_h

#include "rbuttons.h"			/* FACE_TV "button devices"	*/
#include "tvyesno.h"			/* FACE_TV dialog Yes/No types	*/
#include "tv_menu.h"			/* FACE_TV dialog menu types	*/


/************************************************************************
** Some convenient data types.  All this stuff was copped from the
** mod_dac and dt2801a modules of MODAPP, and stripped down just
** for creating a very simple testbed for the FACE_TV code.
*************************************************************************/

#define AMPL_ONE 10000			/* our version of "1"		*/
#define DAC_RATE 10000			/* general default DAC rate 	*/
#define DACNSIZE	  15+1		/* size of the name string	*/
#define NOTESIZE	 120+1		/* a large string		*/
#define MAX_DAC_VOLTAGE	   9.9951	/* the realistic board maximum	*/
#define MAX_DAC_OUTPUT	4095		/* the board can put out this	*/
#define MIN_DAC_VOLTAGE	  -9.9951	/* the realistic board minimum	*/
#define MIN_DAC_OUTPUT	   1		/* ditto			*/

typedef int DACSignal;
typedef char DacnString[DACNSIZE];	/* test of String datatype	*/
typedef char CharString[DACNSIZE-1];	/* test of ByteString datatype	*/
typedef char NoteString[NOTESIZE];	/* test of SCROLL_END feature	*/

typedef enum
{
    DT2801_DEVICE = 0,
    NUCLEUS_DEVICE,
    LSPSS_DEVICE,
    TEST_DEVICE,			/* calls test routines		*/
    MISSING_DEVICE

} DeviceType;


/************************************************************************
** DacByte
**
**	We define the different types of DAC data (apart from the
** normal types such as Integer and Float).  We use them in the
** sample menu shown in FACE_BOX.MEN.  Used for testing
** ExtendedDescriptors.
**
** MidByte
**
**	Similar in concept, but used for testing MappedFieldDescriptors,
** which are a little more complex than ExtendedDescriptors.
**
*************************************************************************/

typedef enum
{
    DAC_FLOAT		= 0,
    DAC_INTEGER,
    DAC_UNSIGNED_BYTE

} DacByte;

typedef enum
{
    MID_BYTE		= 0,
    MID_SBYTE,
    MID_STRING,
    MID_PART

} MidByte;


/************************************************************************
** DACParameters (dialog box)	[stolen and modified from mod_dac]
**
**	Just a good, complex test structure.
**
*************************************************************************/

typedef struct
{
    DeviceType device;		/* device-type radio button		*/
    DacnString name;		/* nickname for the device?		*/
    CharString max;		/* bogus field for dialogue testing	*/
    double outputRate;		/* DAC sampling rate			*/
    int nPoints;		/* max number of points in the buffer	*/
    YesNoType testCode;		/* bogus test code for showing Yes/No's	*/

#ifdef USE_DACRATE_CODE_INSTEAD	/* I have a more important test now	*/
    unsigned dacRate;		/* a mappable field			*/
#else
    NoteString note;		/* string that is scrollable		*/
#endif

    int pt_start;		/* start point (usually 0)		*/
    double us_start;		/* start time (micro-sec, usually 0)	*/
    int pt_end;			/* end point (sometimes nPoints-1)	*/
    double us_end;		/* end time (in microseconds)		*/
    int dacMin;			/* lowest digital value (usually 0)	*/
    double mVmin;		/* lowest signal level in mV		*/
    int dacMax;			/* highest digital level		*/
    double mVmax;		/* highest signal level in mV		*/

    double calibFreq;		/* calibration frequency		*/
    double calibVolts;		/* calibration voltage			*/

} DACParameters;


/************************************************************************
** MIDParameters (dialog box)
**
**	Just a good, complex test structure if MappedFieldDescriptors.
**
*************************************************************************/

typedef struct
{
    char name[10];
    unsigned char tempo;
    signed char pan;
    char part;

} MIDParameters;


/************************************************************************
** EXPParameters (dialog box)	[stolen and modified from mod_exp]
**
**	Just a good, complex test structure.
**
*************************************************************************/

/************************************************************************
** Various EXP macros
**
**	They had meaning in the original MODAPP code [mod_exp.men],
** but here they are included just to satisfy the compiler.
**
*************************************************************************/

#define NUMB_OUT		  4
#define MAX_REVERSALS		 48
#define MINUS_INFINITY_DB	-99.0


/************************************************************************
** Various sample typedefs
*************************************************************************/

typedef int DataWord;
typedef DataWord ReverseArray[MAX_REVERSALS];

typedef enum
{
    INTENSITY_EXP	= 0,
    FREQUENCY_EXP,
    DURATION_EXP,
    PULSE_DUR_EXP,
    GAP_EXP,
    MOD_DEPTH_EXP,
    MOD_FREQ_EXP,
    MOD_PHASE_EXP

} ExperimentType;

typedef enum
{
    DETECTION_EXP	= 0,
    DISCRIMINATION_EXP

} ExperimentComparison;

typedef enum
{
    STEP_LINEAR		= 0,
    STEP_NONLINEAR

} Linearity;


/************************************************************************
** ExpParameters (dialog box)	[mod_exp]
**
**	An interface between the experimental-parameter dialog box
** and the AFCTask class.
**
**	Note the extra padding, which gives us some minor room to
** expand and still be able to read older configuration files.
** When the padding is used up, it's time to byte-edit your old
** configuration files, or recreate them!
**
*************************************************************************/

typedef struct
{
    ExperimentType expType;		/* type of experiment radiobox	*/
    ExperimentComparison expCode;	/* type of comparisons made	*/
    ResponseType responseDevice;	/* device subject can use	*/
    int numbCorrect;			/* number correct to change	*/
    int afcIntervals;			/* number of intervals (2 only)	*/
    int numbRevQuit;			/* number of 2-AFC reversals	*/
    int numbOut;			/* number to throw out at first	*/
    long afcSpeed;			/* long code for testing Longs	*/
    double afcStep;			/* control over step-size	*/
    double afcHalfStep;			/* control over half-step size	*/
    double afcFloor;			/* control over the floor value	*/
    double afcCeiling;			/* control over ceiling value	*/
    YesNoCheck valueTrack;		/* controls display of values	*/
    YesNoCheck stimPeek;		/* controls display of interval	*/
    YesNoCheck noisePeek;		/* controls display of noise	*/
    Linearity stimLinearity;		/* linearity of stimulus levels	*/
    Linearity stepLinearity;		/* linearity of steps		*/

    char padding[10];			/* room for expansion		*/

} ExpParameters;


#endif							/* } FACE_BOX_h	*/
