/************************************************************************
**
** @(#)boxtools.h	06/03/93	Chris Ahlstrom
**
**	C++ version
**
**	Help support for banner-presentations and error-message displays.
**
*************************************************************************/

#if !defined(BOXTOOLS_h)				// { BOXTOOLS_h
#define BOXTOOLS_h

#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TLabel
#define Uses_TPoint
#define Uses_TRect
#define Uses_TView
#include <tv.h>			// Turbo Vision functionality
#include <util.h>		// Turbo Vision utility functions

#include <dos.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>


/************************************************************************
** Handy dandy #defines for annunciation and other routines!
*************************************************************************/

#define SCROLL_END	  0x00FFu	// marks end of the viewbox
#define SCROLL_END_CHAR	 "\xFF"		// handy for readability

#define STRINGMAX	  512		// largest strings we'll allow
#define SCREENWIDTH	   80		// too bad it's hardwired
#define SCREENHEIGHT	(25-2)		// ditto

#define OK_SIZE    9			// size of each OK/Cancel bar
#define OK_SPACE   4			// distance between each bar
#define OK_THICK   2			// thickness of the bars
#define OK_LENGTH 2*(OK_SIZE+OK_SPACE)	// total length of OK/Cancel bars
#define OK_BOTTOM  1			// distance of bar from bottom
#define OK_ADJUST  5			// another magic number

#define BOX_WIDTH   16			// width of the annunciator box
#define BOX_HEIGHT   5			// height of the annunciator box
#define BOX_TOP      2			// desired spacing around value
#define BOX_BOTTOM   1			// distance of bar from bottom
#define BOX_MARGIN   2			// desired spacing around value
#define BOX_EXCESS   2			// padding for enhanced viewability
#define VAL_WIDTH (BOX_WIDTH-2*BOX_MARGIN-1)	// allowable width
#define VAL_MIN	  -99999.0		// desultory checkpoint
#define VAL_MAX	   99999.0		// desultory checkpoint
#define VAL_FLOAT "%8.3f"		// desultory format string
#define VAL_INT   "%6d"			// desultory format string

#define MAX_HEIGHT	(SCREENHEIGHT - BOX_TOP - OK_THICK - OK_BOTTOM)
#define MAX_WIDTH	(SCREENWIDTH - 2 * BOX_MARGIN)


/************************************************************************
** Handy dandy dialog box functions for annunciation!
*************************************************************************/

extern TPoint banner_size	// calculates the 2-D size of a string
(
    char *message,		// the text string
    int xpadding = 0,		// optional padding to add to width
    int ypadding = 0		// optional padding to add to height
);
extern TPoint banner_list_size	// calculate 2-D size of a string-array
(
    char *string[],		// the array of strings
    int xpadding = 0,		// optional padding to add to width
    int ypadding = 0		// optional padding to add to height
);
extern TRect banner_spec	// calculates size and central location
(
    TPoint textbox		// dimensions of the text string
);
extern TRect banner_OK		// calculates location of an OK button
(
    TRect banner		// dimensions of the dialog box
);
extern TRect banner_OK_Cancel	// calculates location of OK with Cancel
(
    TRect banner		// dimensions of the dialog box
);
extern TRect banner_Cancel	// calculates location of Cancel button
(
    TRect banner		// dimensions of the dialog box
);
extern TDialog *flashHandler	// displays a string very quickly in a box
(
    TDeskTop *desktop,		// where to display the box
    int location_x,		// the desired row to display it at
    int location_y,		// the desired column to display it at
    char *message,		// the pre-formatted string to display
    char *label			// a short label for the dialog box
);
extern TDialog *closeBox	// removes a "Box" from the desktop
(
    TDialog *pd,		// pointer to the dialog
    unsigned delay_ms		// optional delay in milliseconds
);
extern TDialog *intBox		// displays an integer on the desktop
(
    TDeskTop *desktop,		// where to display the box
    int location_x,		// the desired row to display it at
    int location_y,		// the desired column to display it at
    char *string,		// a short label for the dialog box
    int value			// the value to display
);
extern TDialog *floatBox	// displays a double on the desktop
(
    TDeskTop *desktop,		// where to display the box
    int location_x,		// the desired row to display it at
    int location_y,		// the desired column to display it at
    char *string,		// a short label for the dialog box
    double value		// the value to display
);
extern TDialog *stringBox	// displays a string on the desktop
(
    TDeskTop *desktop,		// where to display the box
    int location_x,		// the desired row to display it at
    int location_y,		// the desired column to display it at
    char *string,		// a short label for the dialog box
    char *value			// the string value to display
);




#endif							// } BOXTOOLS_h
