/************************************************************************
**
** @(#)announce.h	04/16/93	Chris Ahlstrom
**
**	C++ version
**
**	Various banner-presentations and error-message displays.
**
**	At attempt to create an extensible class for handling errors.
** This class provides basic start-up, close-out, and display facilities.
** The new application then provides more messages.
**
*************************************************************************/

#if !defined(ANNOUNCE_h)				// { ANNOUNCE_h
#define ANNOUNCE_h

#define Uses_TButton
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TInputLine
#define Uses_TLabel
#define Uses_TPoint
#define Uses_TRadioButtons
#define Uses_TRect
#define Uses_TView
#include <tv.h>			// Turbo Vision functionality

#include "tvyesno.h"		// FACE_TV Yes-No radio button and types


#define ERR_STRING_SIZE	82	// for the size of static buffers


/************************************************************************
** ErrorCode
**
**	A base list of the more common error messages.
**
*************************************************************************/

typedef enum
{
    ERR_SHOW_NO_MESSAGE	= -2,	// behavior needs no flagging to user
    ERR_USER		= -1,	// the user (caller) provided the message
    ERR_NONE		=  0,	// not an error message

    ERR_BAD_MESSAGE,		// programmer error
    ERR_BAD_MESSAGECODE,	// programmer error
    ERR_COMMAND_UNIMPLEMENTED,	// un-implemented command
    ERR_NULL_POINTER,		// routine was passed a NULL pointer
    ERR_OBJECT_NOT_CREATED,	// an instantiation failed
    ERR_TESTCODE,		// function is altered because of test mode
    ERR_TOO_MANY_WINDOWS,	// too many windows created
    ERR_NO_MEMORY,		// couldn't allocate the buffer
    ERR_TINY_BUFFER,		// need to allocate more for this purpose
    ERR_NO_MATCHING_FILES,	// no files match the wild-card filespec
    ERR_FILE_NOT_FOUND,		// desired file was not found
    ERR_FILE_OPEN,		// could not open it
    ERR_FILE_WRITE,		// could not write it
    ERR_FILE_READ,		// could not read it
    ERR_USER_ABORT,		// user terminated the action by hand
    ERR_DATA_ABORT,		// data problem terminated the action by hand
    ERR_RECEIVING_DATA,		// an error in receiving data
    ERR_SENDING_DATA,		// an error in sending data
    ERR_DIALOG,			// bad dialog box setup

    ERR_LAST_GENERIC_ERROR	// a sop to much older programs, not used

} ErrorCode;

#if defined(USE_GEN_ERRORS)			// { USE_GEN_ERRORS

static char *genErrors[] =
{
    "%%Programmer: Bad message%%",
    "%%Programmer: Message-code too high!%%",
    "%%Programmer: Command unimplemented",
    "%%Programmer: Passed a NULL pointer",
    "An object could not be created",
    "Executing test code only",
    "Too many windows",
    "Not enough memory for buffer",
    "You need to allocate more memory",
    "No matching files",
    "File not found",
    "Can't open file",
    "Can't write file",
    "Can't read file",
    "User break; action aborted",
    "Date error; action aborted",
    "Error receiving data; action aborted",
    "Error sending data; action aborted",
    "Bad dialog box setup"
};
#define genErrorsLength ((unsigned) (sizeof(genErrors) / sizeof(char *)))

#endif						// } USE_GEN_ERRORS


/************************************************************************
** UserMessages
**
**	This class supports messages that are somewhat ad hoc... the
** messages are passed as an argument, rather than being defined in
** a long list of messages read in (or created) when the message object
** is being created.
**
**	The xBox annunciators below all have similar parameter schemes.
** See announce.cpp for a complete discussion.
**
*************************************************************************/

class UserMessages
{
public:

    UserMessages			// assume no message exist
    (
	TDeskTop *desk			// the desktop for display
    );
    UserMessages			// construct messages from memory
    (
	TDeskTop *desk,			// the desktop for display
	char **msg_buffer,		// pointer to array of messages
	unsigned length			// the number of pointers
    );
    UserMessages			// construct messages from a file
    (					// NOT READY YET
	TDeskTop *desk,
	char *msg_file_name
    );

    // ~Usermessages();			// CREATE WHEN FILE CONSTRUCTOR EXISTS

    // Note the following overloaded functions (this is fun!)

    virtual void errorHandler		// a message is provided
    (
	char *message
    );
    virtual void errorHandler		// a message code is provided
    (
	int messagecode
    );
    virtual void errorBox		// Turbo Vision message box
    (
	char *message,			// normal string or printf string
	unsigned value			// optional value to put in message
    );
    void msgHandler(char *msg);		// displays quick information
    ErrorCode bannerHandler(char *msg);	// displays banners (not so quick)
    YesNoType confirmation		// asks for confirmation
    (
	char *string
    );
    int prompt(char *string);		// prompts for continuing
    ErrorCode lastError();		// gets the last error-code

private:

    TDeskTop *deskTop;			// which desktop to paste it on
    char **userMessages;		// object's possible messages
    unsigned userMessagesLength;	// number of messages stored
    ErrorCode Error;			// last error code that occurred
    int usedErrorFile;			// 1 if the file constructor was used

    static char errorString[ERR_STRING_SIZE];	// for errorBox() formatting
};

#if defined(USE_GEN_ERRORS)			// { USE_GEN_ERRORS

char UserMessages::errorString[ERR_STRING_SIZE];	// static defined

#endif						// } USE_GEN_ERRORS

#endif							// } ANNOUNCE_h
