/************************************************************************
**
** @(#)x_delay.h	01/05/94	Chris Ahlstrom
**
**  ----------------------------------
**  73340.26@compuserve.com
**  ----------------------------------
**
**  C/C++
**
**	Defines a universally useful set of parameters for setting
** up a set of delay timers.
**
**	The parameters themselves are stored in the
** DelayParameters structure.  If this structure ever changes,
** we will have to edit many other files, perhaps:
**
**		WINDELAY.ID
**		WINDELAY.DLG
**		WINDELAY.BOX
**		X_DELAY.H
**		X_DELAY.BOX
**		XAPPDATA.H
**
** Note the following, which applies to all dialog-box data structures:
** You do not need to create a special version of the parameters-data-
** structure for Windows, because the doDialog() function of the
** WDialogBox class in the FACE_WIN library knows how to construct the
** proper-size dialog-data-structure on the fly.  You need only create
** one that exactly represents the data as it will be *used*.
**
*************************************************************************/

#if !defined(X_DELAY_h)					/* { X_DELAY_h	*/
#define X_DELAY_h


/************************************************************************
** DelayParameters (for dialog box)
**
**	An interface between the delay-parameter dialog box
** and the AFCTask class.
**
**	The array of 5 delay times could be written like the following,
** but we want the ease of array processing.  See the #defines below.
**
**	int beforeInterval;
**	int forStimulus;
**	int betweenInterval;
**	int forFeedback;
**	int extraDelay;
**
*************************************************************************/

#define AFC_DELAYS_SUPPORTED	 5
#define DEL_NAME_DIALOG_LENGTH	32

typedef enum
{
    DELAY_BEFORE_INTERVAL	= 0,
    DELAY_FOR_STIMULUS,
    DELAY_BETWEEN_INTERVAL,
    DELAY_FOR_FEEDBACK,
    DELAY_EXTRA,

    DELAY_MAX

} DelayCodes;

typedef struct
{
    char Name[DEL_NAME_DIALOG_LENGTH+1];	/* descriptive name	*/
    int timerDelay[DELAY_MAX];			/* 5 timer times	*/
    int scaleFactor;				/* a delay in msec	*/
    int baseID;					/* lowest timer ID	*/

} DelayParameters;



#endif							/* } X_DELAY_h	*/


