/************************************************************************
**
** @(#)tv_confg.h	12/20/93	Chris Ahlstrom
**
**	C++ version
**
**	Very similar to winconfg.cpp, but designed for TurboVision.
**
*************************************************************************/


#if !defined(TV_CONFG_h)				// { TV_CONFG_h
#define TV_CONFG_h


#if defined(__BORLANDC__)
#pragma warn -amp		// ignore superfluous "&" warning
#endif

#define Uses_TChDirDialog
#define Uses_TDeskTop
#define Uses_TFileDialog
#include <tv.h>

#if defined(__BORLANDC__)
#pragma warn .amp		// reset initial status of "&" warning
#endif


#include "filedlg.h"		// FilePicker class for DOS (TurboVision)


/************************************************************************
** CFG_MAGIC_STRING_LENGTH
**
**	This is the length of the magic string used for verifying
** that a file is indeed the right kind of file for reading in a list
** of BasicConfigurations.  The length will be the same for all classes.
** [The only such class is SimpleConfiguration at present.]
**
**	It is tied to the class.  All classes will use this string
** in their reads/writes.  All classes will define their own strings
** and lengths.
**
** CFG_MAGIC
**
**	This is the part common to all configurations.
**
** CFG_PERSONAL_MAGIC
**
**	This is the part of the string peculiar to the program.
** The string can be null, in which case it is ignored.
**
*************************************************************************/

#define CFG_MAGIC			23
#define CFG_PERSONAL_MAGIC		 8
#define CFG_OFFSET			CFG_MAGIC
#define CFG_MAGIC_STRING_LENGTH (CFG_MAGIC+CFG_PERSONAL_MAGIC+1)


/************************************************************************
** ForceNameFlag
**
**	A glorified set of #defines.
**
*************************************************************************/

typedef enum
{
    PREVIOUS_NAME_UNLESS_INACTIVE	= 0,	// usually passed as default
    FORCE_NEW_NAME

} ForceNameFlag;


/************************************************************************
** BasicConfiguration structure
**
**	We are going to support configurations in a very simple and
** inelegant way, until there's time to really learn about streaming
** and container classes.
**
**	For our purpose, a BasicConfiguration is simply a location
** in memory of a given size.  This location will be read into and
** written from, in order to set memory to a known state.
** 
*************************************************************************/

typedef struct
{
    void *configuration;
    int configurationSize;

} BasicConfiguration;


/************************************************************************
** SimpleConfiguration class
**
**	This class maintains an array of BasicConfigurations by
** specifying a file-name for the configurations, and providing
** ways of reading and writing them.
**
**	The programmer simply creates a null-terminated array of
** BasicConfigurations in a header file.
**
**	This easy scheme supports expansion (adding more configurations)
** as long as the new configurations are tacked on at the end of the
** array, and as long as the old configurations do not change in
** size.
**
**	No checks are made as to correctness of the configurations.
** The bad dialog boxes should tell all!
**
*************************************************************************/

class SimpleConfiguration
{

public:

    SimpleConfiguration			// constructor
    (
	TDeskTop *aparent,		// the parent window of object
	char *filename,			// default filename for config file
	BasicConfiguration *cfglist,	// a list of data areas
	char *magic = 0			// magic string, if applicable
    );

    virtual ~SimpleConfiguration();	// destructor

    virtual int read			// reads in the configuration
    (
	ForceNameFlag newname = PREVIOUS_NAME_UNLESS_INACTIVE
    );
    virtual int write			// writes the configuration
    (
	ForceNameFlag newname = PREVIOUS_NAME_UNLESS_INACTIVE
    );
    const char * errorMsg();		// quick and dirty error messages

protected:

    BasicConfiguration *configList;	// points to the list

private:

    FilePicker *configFile;		// it "has-a" file associated with it
    int errorCode;			// holds latest error

    char *magic;			// magic area for class, modifiable

    static const char * const MAGIC;	// the constant portion

};

#endif							// } TV_CONFG_h
