/************************************************************************
**
** @(#)tvyesno.h	04/29/92	Chris Ahlstrom
**
**	C++ version, depends upon Turbo Vision, too.
**
**	Simply defines a static array that describes a very
** simply set of radio-buttons:  yes or no buttons.
**
**	Note the "Not Applicable" entry is no longer in service.
**
**	Note that it is sometimes better to use a CheckBox instead, as
** shown in the following two alternatives:
**
**	1.  Radio buttons:
**
**		Save the File?
**		( ) No
**		(.) Yes
**
**	2.  Check box:
**
**		[X] Save the File
**
**	In either case, the YesNoType enum describes all possible
** values.
**
*************************************************************************/

#if !defined(TVYESNO_h)				/* { TVYESNO_h		*/
#define TVYESNO_h

#define Uses_TCheckBoxes
#define Uses_TRadioButtons
#include <tv.h>					/* Turbo Vision code	*/


/************************************************************************
** YesNoType, YesNoCheck, (mod_type.h) and YesNoButtons
**
**	Selections for simple YES/NO radio-buttons.  Be sure to keep
** these structures in synchrony.
**
**	Note that we add 6 to the width of the widest option, to hold
** the place of the " ( ) " in the option list, plus one more space on
** the right of the option list.
**
**	XX is just a placeholder to make it visually obvious that
** the data is filled in by the program.
**
**	Any program that wants to define the static should
** #define USE_YES_NO_BUTTONS.  For backward compatibility, we've left
** in the option to define YES_NO_BUTTONS to fake the header file
** into thinking the static has already been defined.
**
**	The best policy is to #define USE_YES_NO_BUTTONS at the
** earliest possible point in the the main program.
**
**	Now, sometimes it's more compact to display a Yes/No options
** as a one-liner Checkbox.  So, we define an enumeration for that
** type of box, too.
**
*************************************************************************/

typedef enum
{
    NO	= 0,						/* "no"		*/
    YES							/* "yes"	*/

} YesNoType;

typedef enum
{
    CHECK_NO	= 0,				/* no			*/
    CHECK_YES					/* yes			*/

} YesNoCheck;

#if defined(USE_YES_NO_BUTTONS) && !defined(YES_NO_BUTTONS)
#define YES_NO_BUTTONS			/* { USE_YES_NO_BUTTONS		*/

#define XX	0				/* "to be filled in"	*/

#if defined(DEUTSCHE)					/* { DEUTSCHE	*/

static char *YesNoButtons[] =
{
    "~N~ein",
    "~J~a",
    NULL
};

#else							/* }{ DEUTSCHE	*/

static char *YesNoButtons[] =
{
    "~N~o",
    "~Y~es",
    NULL
};

#endif							/* } DEUTSCHE	*/

const int YesNo_size = (sizeof(YesNoButtons)/sizeof(char *)-1);
const int YesNo_L    = (3+6);			/* length of largest	*/

#else					/* }{ USE_YES_NO_BUTTONS	*/

//extern const int YesNo_size;
//extern const int YesNo_L;

#endif					/* } USE_YES_NO_BUTTONS		*/


#endif						/* } TVYESNO_h		*/

