/************************************************************************
**
** @(#)tvscreen.h	08/13/93	Chris Ahlstrom
**
**	C++
**
*************************************************************************/

#if !defined(TVSCREEN_h)				/* { TVSCREEN_h	*/
#define TVSCREEN_h


#if !defined(USE_TURBO_VISION)
#define USE_TURBO_VISION
#endif

#define screenmsg(a, b, c)	tvScreenmsg((a), (b), (c))


extern

#ifdef __cplusplus				/* { __cplusplus	*/
"C"
#endif						/* } __cplusplus	*/

int tvScreenmsg
(
    int use_io,			// whether to ignore output
    void *handle,		// bogus for now
    char *string		// string to display
);

#if defined(__cplusplus)				// { __cplusplus

#define Uses_TWindow
#define Uses_TApplication
#define Uses_TRect
#define Uses_TTerminal
#define Uses_MsgBox
#define Uses_otstream
#define Uses_TDeskTop
#include <tv.h>


/************************************************************************
** TWindowScreen class
**
**	Largely based on the handy TTerminal class provided by Borland.
** Long live Philippe Kahn!  (I'd like to see a mud-wrestling contest
** between him and Bill Gates.)
**
*************************************************************************/

class TWindowScreen : public TWindow
{

public:

    TWindowScreen
    (
	const TRect& bounds,	// initial size rectangle for window
	const char *atitle,	// title for the top of the frame
	short anumber,		// bogus number for the window (wmNoNumber)
	ushort bufsize		// buffer size for window
    );
    ~TWindowScreen();

    TTerminal *makeInterior
    (
	TRect bounds, ushort abufsize
    );

    friend TWindowScreen *startWindowScreen
    (
	TDeskTop *desktop,
	unsigned buffsize
    );
    friend void doScreenMessage
    (
	TWindowScreen *handle,
	char *message
    );

private:

    TTerminal *screenInterior;		// points to window interior

    /********************************************************************
    ** For some reason, cannot pass the pointer "screenOStream" without
    ** causing weird problems (see the unuseable code in the USEABLE_CODE
    ** #if in tvscreen.cpp).
    **
    ** otstream *screenOStream;		// one output text stream per interior
    **
    *********************************************************************/
};


/************************************************************************
** Friend functions of the TWindowScreen class
*************************************************************************/

extern void doScreenMessage		/* helper function		*/
(
    TWindowScreen *handle,
    char *message
);
extern TWindowScreen *startWindowScreen	/* helper for creating screens	*/
(
    TDeskTop *desktop,
    unsigned buffsize = 64000U
);

#endif							// } __cplusplus

#endif							/* } TVSCREEN_h	*/
