/************************************************************************
**
** @(#)tmouse.h		05/27/92	Chris Ahlstrom
**
**	Mouse routines for local usage, to supplement Turbo Vision.
**
*************************************************************************/

#if !defined(TMOUSE_h)				/* { TMOUSE_h	*/
#define TMOUSE_h


#define MOUSEBIOS	0x33		// interrupt to control mouse

#define READMOUSE	0x03		// function to read mousy stuff
#define MOUSEPOSITION	0x04		// function to move the mouse
#define READMICKEY	0x0B		// function to read mickeys


/************************************************************************
** Return codes for mouseButtonCheck()
*************************************************************************/

#define NO_MOUSEBUTTON		0x00
#define LEFT_MOUSEBUTTON	0x01
#define RIGHT_MOUSEBUTTON	0x02
#define BOTH_MOUSEBUTTONS	0x03
#define CENTER_MOUSEBUTTON	0x04

#define MOUSE_CHAR_WIDTH	 8
#define MOUSE_CHAR_HEIGHT	 8	/* text-mode dependent		*/


/************************************************************************
** readYmickey()
**
**	A global function to return the number of vertical mickeys
** the mouse moved since the last call to readYmickey.  There is no
** correspondent routine in TurboVision.
**
** readMouseButtons()
**
**	Reads the mouse buttons.  I'm not satisfied with the behavior
** of mouseEvent().
**
** setMousePosition()
**
**	Puts the mouse at the desired location.
**
**	I copped these routines from the MSMOUSE library and tailored
** it to our limited usage.
**
************************************************************************/

extern int readYmickey
(
    void
);
extern int readMouseButtons
(
    void
);
extern void setMousePosition
(
    int x,
    int y
);


#endif							/* } TMOUSE_h	*/
