/************************************************************************
**
** @(#)timerctl.h	01/05/94	Chris Ahlstrom
**
**	C++ Borland/Microsoft
**
*************************************************************************/

#if !defined(TIMERCTL_h)				// { TIMERCTL_h
#define TIMERCTL_h

#include "timerctl.err"		// TimerError type declaration

#define TIMER_IGNORE_COUNT	(-1)


/************************************************************************
** class TimerControl
*************************************************************************/

class TimerControl
{
    friend void deleteTimer		// deletes one or more linked timers
    (
	TimerControl *timer		// uses the timer->Next member
    );

public:					// constructor & destructor

    TimerControl			// constructor
    (
	void *master,			// points to TDeskTop or HWND
	int number = 1,			// ID code for the timer
	unsigned duration = 100,	// minimum duration of timer (msec)
	int count = TIMER_IGNORE_COUNT	// times to allow timer-handling
    );

    virtual ~TimerControl();		// destructor

    virtual int setupTimer		// sets up the timer
    (
	unsigned duration
    );
    virtual int timerDelay ();		// implements a delay function
    virtual int disableTimer ();	// renders the timer unuseable
    virtual int attach			// links two timers (for lists)
    (
	TimerControl *lasttimer
    );
    TimerControl *next ();		// returns the next pointer

    int decrementCount ();		// gives access/control over Count
    int ID;				// ID code of timer
    void *Handle;			// window/desktop handle

public:					// public access functions

    const char *getErrorMsg (void);	// pointer to last error message

    int isError (void)			// get cheap error status in-line
    {
	return (errorCode != 0);
    }

protected:				// internal functions

    virtual void setErrorCode		// set errorCode and errorMsg
    (
	int index
    );
    int getErrorCode (void)		// get code (derived objects only)
    {
	return errorCode;
    }

protected:				// internal error message fields

    /********************************************************************
    ** Callers can call isError() to see if an error occurred.  Some
    ** functions also return error codes.  In either case, if an error
    ** occurs, the caller can get the message by calling
    **
    **		getErrorMsg()
    **
    *********************************************************************/

    const char *errorMsg;		// last error message
    const char * const * errorMsgList;	// if used, a list of messages
    const int errorMsgCount;		// the number of messages in list
    int errorCode;			// message to the caller

    unsigned Duration;			// duration of timer (ms)
    int Count;				// times to handle the timer
    int Useable;			// is timer working?
    TimerControl *Next;			// pointer to next timer

};



#endif							// } TIMERCTL_h

