/************************************************************************
**
** @(#)textmode.cpp	04/01/93	Chris Ahlstrom
**
**  ------------------------
**  73340.26!compuserve.com
**  ------------------------
**
**	Implements simple control of the text mode of the DOS screen.
** Allows the programmer to select the modes allowed by the Borland
** C function textmode().
**
*************************************************************************/

#define TEXTMODE_cpp

#include "textmode.h"


/************************************************************************
** TextMode::TextMode
*************************************************************************/

TextMode::TextMode
(
    int startmode			// initial text mode
)
{
    textMode = startmode;		// the mode to use next
    chngMode = 0;			// cause the mode to be changed
    textmode(startmode);
}


/************************************************************************
** TextMode::changeMode
**
**	Checks the chngMode field; if non-zero, the text mode is
** changed to textMode, and chngMode is zeroed.
**
**	The caller must redraw() itself, if necessary.
**
*************************************************************************/

void
TextMode::changeMode ()			// changing of the text mode
{
    if (chngMode)
    {
	chngMode = 0;
	textmode(textMode);
    }
}
