/************************************************************************
**
** @(#)rbuttons.h	01/03/94	Chris Ahlstrom
**
**	This module interfaces C++ with code for handling various kinds
** of button devices.
**
**	Also defines constants for the Turbo Vision implementation of
** response support.
**
*************************************************************************/

#if !defined(RBUTTONS_h)				// { RBUTTONS_h
#define RBUTTONS_h


/************************************************************************
** ResponseType
**
**	Simply selects the device to use.  We don't allow simultaneous
** interchangeable use of all devices.
**
**	MOUSE_POINT_RESPONSE is not yet supported.
**
*************************************************************************/

typedef enum
{
    MOUSE_RESPONSE	= 0,		// left or right buttons
    KEYBOARD_RESPONSE,			// 1, 2, or E key
    KOALA_RESPONSE,			// left or right buttons
    MOUSE_POINT_RESPONSE		// click in 1st, 2nd, or 3rd section

} ResponseType;


/************************************************************************
** Response
**
**	All responses are mapped onto a two-button response device.
**
**	BUTTON_3 and ALL_BUTTONS are not yet supported.
**
** KeyResponse
**
**	The keys as mapped onto Response values.
**
*************************************************************************/

typedef enum
{
    NO_BUTTON		= 0x00,
    BUTTON_1		= 0x01,
    BUTTON_2		= 0x02,
    BUTTON_3		= 0x04,
    BOTH_BUTTONS	= (BUTTON_1+BUTTON_2),
    ALL_BUTTONS		= (BOTH_BUTTONS+BUTTON_3)

} Response;

typedef enum
{
    KEY_NO_BUTTON	= 0,
    KEY_BUTTON_1	= '1',
    KEY_BUTTON_2	= '2',
    KEY_BUTTON_3	= '3',
    KEY_BOTH_BUTTONS	= 'B',
    KEY_BOTH_ESCAPE	= '\x1B',
    KEY_ALL_BUTTONS	= 'A'

} ResponseKey;


/************************************************************************
** ResponseButton base class
**
**	The protected member responseDevice is of little use at the
** moment.
**
**	The protected member lastResponse is useful perhaps for
** doing tricky but too-tricky things (e.g. two-key double clicks),
** or for saving the status so that a Windows mouse-handler routine
** can decide what to do with it.
**
*************************************************************************/

class ResponseButton
{

public:

    ResponseButton				// constructor
    (
	ResponseType device			// kind of device
    );

    virtual ~ResponseButton ();			// destructor

    int checkAbort ();
    int waitKey ();
    int getLastResponse ();

    virtual int readKey ();			// default support is keyboard

protected:

    ResponseType responseDevice;		// default device is keyboard
    Response lastResponse;			// previous response

};


#endif							// } RBUTTONS_h

