/************************************************************************
**
** @(#)menubars.h	04/01/93	Chris Ahlstrom
**
**  ------------------------
**  73340.26!compuserve.com
**  ------------------------
**
** C++ version
**
**	Class for implementing generic menu bars and menu entries.
**
**	The structs were originally defined in tvmenus.h.
**
*************************************************************************/

#if !defined(MENUBARS_h)				// { MENUBARS_h
#define MENUBARS_h


/************************************************************************
** Turbo Vision setup section
**
**	Although we could strip out some unnecessary #defines below,
** it is likely that the main program will eventually use almost all of
** them anyway.
**
**	Note the two sections:  declarations needed only in the main
** module, and declarations needed in other modules.
**
*************************************************************************/

#define Uses_TApplication
#define Uses_TDisplay
#define Uses_TMenu
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TRect
#define Uses_TScreen
#define Uses_TStatusLine
#define Uses_TStatusItem
#define Uses_TStatusDef
#define Uses_TSubMenu
#include <tv.h>				// Turbo Vision code galore!!!


#define MENU_TERMINATE	NULL	// ends the list of items or submenus
#define MENU_END_NEST	NULL	// null "nest" indicates no nested menu
#define MENU_NEWLINE	"\n"	// code for including a separator bar
#define NEWLINE		'\n'	// code for including a separator bar


/************************************************************************
** MenuItems
**
**	Each of these structures represents a single, selectable command
** in a menu.
**
** Menus
**
**	Each of these structures represents a single submenu within
** a menu.  Each submenu then has at least one MenuItems structure
** associated with it.
**
** MenuBar
**
**	Manages an array of main menu items.  Very simply just a list
** of Menus with a count of the number of them in the array.
**
*************************************************************************/

typedef struct
{
    char *item;			// name of the item, as in "~E~xit"
    ushort cmcode;		// cmXXXXX command code for the item
    ushort key;			// keystroke associated with the item
    ushort help;		// specifies whether help is available
    char *label;		// readable label for the keystroke

} MenuItems;

typedef struct
{
    char *submenu;		// name of an item in a submenu
    ushort submenukey;		// the keystroke to bring up the submenu
    int submenucount;		// number of items in the submenu
    MenuItems *items;		// points to an array of items

} Menus;

typedef struct
{
    int barCount;		// number of items in the status bar
    Menus *items;		// points to an array of items

} MenuBar;


/************************************************************************
** NestItems
**
**	Very similar to MenuItems, but has one extra field that
** can optionally pointer to another NestItems list, to support
** nested menus in a fairly straightforward way.
**
**	For examples of MenuItems, see MIDI_EX.CPP; for examples of
** NestItems, see MT32APP.CPP.  Look at the initMenuBar() function
** in these two files.
**
** Nests
**
**	Similar to Menus, but for NestItems.  I could have used
** a union, I suppose.
**
** NestBar
**
**	Manages an array of main menu items.  Very simply just a list
** of Nests with a count of the number of them in the array.
**
*************************************************************************/

typedef const struct NestItems *NestPtr;

struct NestItems
{
    char *item;			// name of the item, as in "~E~xit"
    ushort cmcode;		// cmXXXXX command code for the item
    ushort key;			// keystroke associated with the item
    ushort help;		// specifies whether help is available
    char *label;		// readable label for the keystroke
    NestPtr nest;		// next structure to hook into
};

typedef struct
{
    char *submenu;		// name of an item in a submenu
    ushort submenukey;		// the keystroke to bring up the submenu
    int submenucount;		// number of items in the submenu
    NestPtr items;		// points to an array of items

} Nests;

typedef struct
{
    int barCount;		// number of items in the status bar
    const Nests *items;		// points to an array of items

} NestBar;


/************************************************************************
** StatusItems
**
**	Each of these structures holds an item for the status line at
** the bottom of the screen.
**
** StatusBar
**
**	A list of StatusItems.
**
*************************************************************************/

typedef struct
{
    char *item;			// name of the item, as in "~E~xit"
    ushort cmcode;		// cmXXXXX command code for the item
    ushort key;			// keystroke associated with the item

} StatusItems;

typedef struct
{
    int barCount;		// number of items in the status bar
    const StatusItems *items;	// points to an array of items

} StatusBar;

/************************************************************************
** MenuBarApp
**
**	Not quite sure how to handle this... MenuBarApp needs to use its
** own version of initMenuBar() and initStatusLine(), but the main
** program needs to guarantee that they're called.
**
**	With the current setup, I'm not sure what to do if the program
** wants to temporarily set up some other menu-bars.
**
**	Note then, that MenuBarApp needs no destructor, since TApplication's
** (TProgram's) virtual destructor is sufficient.
**
*************************************************************************/

class MenuBarApp : public TApplication
{
public:

    MenuBarApp				// the constructor
    (
	//const Nests *menubar,		// structure describing menu-bar
	//const StatusBar *statusbar	// structure describing status-bar
    );

    static TMenuBar *initMenuBar	// overrides TProgram member
    (
	TRect r
    );
    static TStatusLine *initStatusLine	// overrides TProgram member
    (
	TRect r
    );
    static TMenuItem *menuBox		// recursively handles lists of menus
    (
	NestPtr n
    );

//private:

    static const NestBar *menuBar;	// a hierarchy of menu-items
    static const StatusBar *statusBar;	// a list of status-line items

};


#endif							// } MENUBARS_h
