/************************************************************************
**
** @(#)korbutt.cpp	01/05/94	Chris Ahlstrom
**
**	This module interfaces C++ with code for handling various kinds
** of button devices; the substrate is Borland's Turbo Vision.
**
*************************************************************************/

#define KORBUTT_cpp

#include <conio.h>		// inp() declaration

#include "korbutt.h"		// KoalaResponseButton class


/************************************************************************
** KoalaResponseButton constructor
*************************************************************************/

KoalaResponseButton::KoalaResponseButton ()
  :
    ResponseButton(KOALA_RESPONSE)
{
}


KoalaResponseButton::~KoalaResponseButton ()
{
}


/************************************************************************
** readKey() override
**
**	Function to read the Koala-pad buttons.
**
**	See the Response typedef in rbuttons.h.
**
*************************************************************************/

int
KoalaResponseButton::readKey ()
{
    int button = (int) NO_BUTTON;

    button = (int) inp(GAME_PORT);		// check game port
    button = BOTH_BUTTONS - ((button>>4) % 4);

    return button;
}


/************************************************************************
** waitKey()
** checkAbort()
** getLastResponse()
**
**	These functions don't need overriding.
**
*************************************************************************/

