/************************************************************************
**
** @(#)filedlg.h	12/09/93	Chris Ahlstrom
**
**	C++ version
**
**	This code was shamelessly abstracted from the FVIEWER demo
** of Borland's Turbo Vision, but has some minor innovations from the
** author.
**
*************************************************************************/


#if !defined(FILEDLG_h)				// { FILEDLG_h
#define FILEDLG_h

#if defined(__BORLANDC__)
#pragma warn -amp		// ignore superfluous "&" warning
#endif

#define Uses_TChDirDialog
#define Uses_TDeskTop
#define Uses_TFileDialog
#include <tv.h>

#if defined(__BORLANDC__)
#pragma warn .amp		// reset initial status of "&" warning
#endif


/************************************************************************
** FilePicker class typedefs and variables
**
** FileAction type:
**
**	actionCode	0 = User cancelled or supplied a null filename;
**			    do not perform the action
**
**			1 = Perform the action
**
** FileActivity type:
**
**	nameActive	0 = User cleared out the filename (if it was
**			    active), or never specified one before.
**			    This should be accompanied by actionCode = 0.
**
**			1 = The user supplied a name, and opted to
**			    perform the option.  If actionCode = 0,
**			    a name was active, but the user pressed the
**			    Cancel button.
**
** FileOperation type:
**
**	See the typedef below; the meaning is obvious.
**
**
*************************************************************************/


typedef enum
{
    FILE_CANCELLED	= 0,
    FILE_PERFORM_ACTION

} FileAction;

typedef enum
{
    FILE_INACTIVE	= 0,
    FILE_ACTIVE,
    FILE_SAME_STATUS

} FileActivity;

typedef enum			// not all these are supported yet
{
    FILE_READ		= 0,
    FILE_WRITE,
    FILE_CREATE,
    FILE_OPEN,
    FILE_DELETE

} FileOperation;


/************************************************************************
** FilePicker class
**
**	We have made a great effort to make all data private.
** Functions are used to access private data.
**
*************************************************************************/


class FilePicker
{

public:

    FilePicker				// constructor
    (
	TDeskTop *desk,
	char *wildcard			// the starting wild-card
    );

    void fileDialog			// requests filename from user
    (
	FileOperation mode
    );
    void chDir();			// for changing DOS current directory
    void makeFileName			// assembles full file specs from cwd
    (
	char *basename,
	char *extension
    );

    // Other functions need to have indirect access to the following

    FileActivity fileActive ( void );	// returns value of nameActive
    FileAction fileAction( void );	// returns value of actionCode
    char *fileSpec( void );		// returns pointer to fpFileSpec[]
    int fileBase( char *destination );	// copies fpFileBase[] to destination
    void inactivateFile( void );	// force request for new filename

private:

    TDeskTop *desktop;			// not sure if should be private

    void pickFile
    (
	char *wildcard,
	char *boxtitle,
	char *fieldtitle,
	ushort options
    );

    FileActivity nameActive;
    FileAction actionCode;

    char fpFileSpec[MAXPATH];
    char fpDrive[MAXDRIVE];
    char fpDirName[MAXDIR];
    char fpFileBase[MAXFILE];
    char fpFileExt[MAXEXT];
    char fpFileName[MAXFILE+MAXEXT+1];

    char wildCard[MAXFILE];		// store the original wild-card

    struct ffblk fileInfo;

};


#endif							// } FILEDLG_h
