/************************************************************************
**
** @(#)dosshell.cpp	04/01/93	Chris Ahlstrom
**
**  ------------------------
**  73340.26!compuserve.com
**  ------------------------
**
**	Implements a simple shell to DOS.
**
*************************************************************************/

#define DOSSHELL_cpp

#include <stdlib.h>             // for exit(), random()
#include <string.h>             // for strlen etc
#include <iostream.h>		// for cout

#include "dosshell.h"


/************************************************************************
** DosShell::DosShell
*************************************************************************/

DosShell::DosShell				// DOS Shell Command
(
    char *newp				// the prompt for new COMMAND.COM
)
{
    newP = newp;			// NULL can be used if desired
}


/************************************************************************
** DosShell::shell
**
**	This routine provides a nice way to get out to DOS to look at
** files and things.  I'm not sure this is robust against a lack of
** memory to shell out.
**
**	The basic method is to turn off the mouse, get the old DOS
** prompt and save it, put out the new DOS prompt, test for a command
** processor, then clear the screen, and shell out to a new copy of
** the command-line interpreter in the environment variable COMSPEC.
** (Might need to handle cases where COMSPEC (and SHELL) are not
** specified).
**
**	Also, note the lack of use of malloc() and free().  As shown in
** that excellent book "Effective C++" by Scott Meyers (Addison-Wesley
** Publishing Company), these should be always be converted to new and
** delete.
**
**	The caller must redraw() itself, if necessary.
**
*************************************************************************/

#define PROMPT_NAME	"PROMPT"			// DOS variable
#define CLEAR_SCREEN	"cls"				// DOS clear-screen
#define FIRST_PROMPT	"Type EXIT to return..."	// initial message
#define COMMAND_SPEC	"COMSPEC"			// the shell's name

void
DosShell::shell ()			// DOS Shell Command
{
    // Get and save the old value of the DOS PROMPT environment variable

    suspend();				// turn off the mouse

    P = getenv(PROMPT_NAME);		// get location of old prompt
    oldP = new char [strlen(P) + 1];	// allocate a place for the prompt
    if (oldP)
    {
	strcpy(oldP, P);		// store the prompt there for awhile
	if (newP)			// if a prompt was provided, then
	    putenv(newP);		// change PROMPT to remind the user

	shIs = system(NULL);		// test for a command processor
	if (shIs != 0)			// can we get a command processor?
	{
	    shIs = system(CLEAR_SCREEN);	// clear the screen
	    cout << FIRST_PROMPT;		// make clear what's happening
	    shIs = system(getenv(COMMAND_SPEC));// spawn out a command shell
	    putenv(oldP);			// restore the old prompt
	    if (shIs == -1)
	    {
		// error processing goes here for errno = one of...
		//
		//	ENOENT   ENOMEM   E2BIG   ENOEXEC
	    }
	}
	delete [] oldP;			// free up the scratch space
    }
    resume();				// turn on the mouse
}

