/************************************************************************
**
** @(#)datatype.h	12/03/93	Chris Ahlstrom
**
**  ------------------------
**  73340.26!compuserve.com
**  ------------------------
**
**	Declares just one thing... the enumeration DataType, which
** helps tv_menu.h (FACE_TV library) and win_menu.h (FACE_WIN library)
** define a universally used type.
**
*************************************************************************/

#if !defined(DATATYPE_h)				// { DATATYPE_h
#define DATATYPE_h


/************************************************************************
** DataType
**
**	We support a very simple set of data types.  There is no
** verification of data entry as the data is entered.  Instead, we
** lets you type what you want.  When you leave the field, it converts
** numeric types to a number.  If your number comes up wrong (usually
** the "wrong" value is a zero), go back, hit Esc, and fix it!
**
**	Provides a straighforward way of generating data for Turbo Vision
** button-boxes.
**
*************************************************************************/

typedef enum
{
    NormalField = -1,		// no special data-type handling needed
    NullField	= 0,		// the field consists only of a label
    Extended,			// ints, longs, & floats with linear remapping
    String,			// string with NULL terminator
    ByteString,			// string without NULL terminator
    UnsignedByte,		// for byte-sized values
    SignedByte,			// signed byte-sized values
    Integer,			// positive and negative short integers
    Hex,			// same as Integer, but hex is hoped for
    LongInteger,		// long integers (copped from Turbo Vision)
    HexAddress,			// long hex (seg:off) (same as long currently)
    Float,			// double-precision numbers
    Checkbox,			// Turbo Vision (TV) check-box
    Radiobox,			// Turbo Vision (TV) radio-button-box
    Checkbyte,			// TV check-box for byte-sizes
    Radiobyte,			// TV radio-button-box for byte-sizes
    DateField,			// simple American mm/dd/yy format
    TimeField,			// simple American hh:mm:ss format
    Money,			// simple American money format $xxxxx.yy
    FloatControl,		// mouse/key control of float numbers

    DataTypeUnused,		// reserved for expansion up to 31

    DataTypeMax = Money		// don't exceed this value

} DataType;


#endif							// } DATATYPE_h
