/************************************************************************
**
** @(#)tmouse.c		05/27/93	Chris Ahlstrom
**
**	This module provides mouse utilities that are functionally
** partly a subset of the regular MSMOUSE routines, but have different
** names and parameter-passing conventions.
**
**	They are defined her for convenience, and to avoid using the
** whole mouse library, since Turbo Vision already provides most of
** the functionality we need.
**
*************************************************************************/

#define TINPMOUS_c

#include <dos.h>

#include "tmouse.h"


/************************************************************************
** LOCAL VERSIONS OF MOUSE ROUTINES
*************************************************************************/

/************************************************************************
** readYmickey
**
**	A global function to return the number of vertical mickeys
** the mouse moved since the last call to readYmickey.
**
**	I copped this routine from the MSMOUSE library and tailored
** it to our limited usage.
**
**	Based on Microsoft mouse function 11
**
**	Reads the motion of the mouse (its displacement since the
** last call), in units of mickeys.  Discards the x displacement, and
** returns the y displacement.  A positive number indicates travel
** downwards.  One mickey is about 1/200th inch of mouse movement.
**
**	Note that even if the mouse cursor is at the edge of its
** area, and stuck there because it can go no farther, this function
** still returns non-zero mickey values as long as the user continues
** to move the mouse.
**
*************************************************************************/

int
readYmickey
(
    void
)
{
    union REGS mousreg;

    mousreg.x.ax = READMICKEY;			// do this function
    int86(MOUSEBIOS, &mousreg, &mousreg);	// call mouse interrupt
    return mousreg.x.dx;			// return vertical movement
}


/************************************************************************
** readMouseButtons
**
** Based on Microsoft mouse function 3
**
**	Returns the status of the mouse buttons.
**
**	button is a bitmask; the following values apply:
**
**	      Bit   Meaning if on
**	     -----  --------------------------------------------
**		0 = left button is down (LEFT_MOUSEBUTTON)
**		1 = right button is down (RIGHT_MOUSEBUTTON)
**		2 = center button is down (CENTER_MOUSEBUTTON)
**		3 to 15 are reserved
**
**	I created this routine because I'm not satisfied with the
** behavior of mouseEvent().
**
*************************************************************************/

int
readMouseButtons
(
    void
)
{
    union REGS mousreg;

    mousreg.x.ax = READMOUSE;
    int86(MOUSEBIOS, &mousreg, &mousreg);	// call the mouse interrupt
    return mousreg.x.bx;
}


/************************************************************************
** setMousePosition
**
** Based on Microsoft mouse function 4
**
**	Places the mouse at position (x,y).  The position is adjusted,
** if necessary, to lie within the confines specified in any previous
** calls to functions 7 and 8 (setmousehoriz() and setmousevert()).
**
**	One problem is that the vertical dimension correction factor
** is text-mode dependent.
**
** Example call:
**
**	setMousePosition(40, 12);
**
*************************************************************************/

void
setMousePosition
(
    int x,
    int y
)
{
    union REGS mousreg;

    mousreg.x.ax = MOUSEPOSITION;
    mousreg.x.cx = x * MOUSE_CHAR_WIDTH;	// convert to mouse units
    mousreg.x.dx = y * MOUSE_CHAR_HEIGHT;	// convert to mouse units

    int86(MOUSEBIOS, &mousreg, &mousreg);	// call mouse interrupt
}

