/************************************************************************
**
** @(#)tinpmous.h	05/27/92	Chris Ahlstrom
**
** C++ version
**
**	Contains, at present, an interface to the menu fields.
** Added support for byte-sized radio-buttons and check-boxes.
**
*************************************************************************/

#if !defined(TINPMOUS_h)				// { TINPMOUS_h
#define TINPMOUS_h

#include "tinput.h"				// for TInputXXX classes
#include "tv_menu.h"				// for Range declaration



/************************************************************************
** MouseButton
**
**	Reflects the possible states (statuses) of the buttons on the
** mouse.  Each button on the mouse is represented by a bit.  If the
** bit is set, then the button was down at the time the status of
** the buttons was obtained.
**
*************************************************************************/

typedef enum
{
    NO_MOUSE_BUTTON	= 0x00,
    LEFT_MOUSE_BUTTON	= 0x01,
    RIGHT_MOUSE_BUTTON	= 0x02,
    BOTH_MOUSE_BUTTONS	= 0x03,
    CENTER_MOUSE_BUTTON	= 0x04

} MouseButton;



/***********************************************************************
** TInputFloatControl
**
**	Class for control of numeric variables using the mouse
** and the up/down arrows on the PC keyboard.
**
************************************************************************/

class TInputFloatControl : public TInputFloat
{

public:				// base class functions & overrides

    TInputFloatControl		// constructor
    (
	const TRect& bounds,	// rectangle for Float's input-line
	int fmaxLen,		// maximum length to use for buffer
	const Range& code,	// range of internal representation
	char *formatstring,	// desired display format
	int mapped,		// should remapping be performed?
	const Range& user,	// range of user's representation
	int exponential,	// 1=using exponential mapping
	int maxmickey,		// highest mouse changes we support
	int maxkey,		// highest key changes we support
	CtrlFunction ctrlf	// function to use for control
    );
    // ~TInputFloatControl();

    virtual void handleEvent(TEvent& event);	// override for mouse handling

protected:			// base class function

    TInputFloatControl( StreamableInit ) : TInputFloat( streamableInit ) {};

public:				// base class pointer

    static const char * const name;

private:			// functions not provided by base class

    void setupMouseMapping	// make equation for mouse<-->user conversions
    (
	void
    );
    void setupKeyMapping	// make equation for key<-->user conversions
    (
	void
    );
    double userMouseMapping	// convert mouse y-value to user range
    (
	int mousevalue		// current value of mouse y-mickey
    );
    double userKeyMapping	// convert key value to user range
    (
	int keyvalue		// current value of key counter
    );
    int mouseMapping		// convert user value to mouse range
    (
	double uservalue	// value of numeric field
    );
    int keyMapping		// convert user value to key range
    (
	double uservalue	// value of the numeric field
    );
    double handleKeyControl	// handle the keystroke properly
    (
	int key			// the keystroke (up or down arrow)
    );
    double handleMouseControl
    (
	void
    );
    int mouseCorrect
    (
	int ypos
    );

private:			// utility functions for mappings

    double userMouseLinear
    (
	double mousevalue
    );
    double userMouseExp
    (
	double mousevalue
    );
    double userKeyLinear
    (
	double keyvalue
    );
    double userKeyExp
    (
	double keyvalue
    );
    double mouseLinear
    (
	double uservalue
    );
    double mouseExp
    (
	double uservalue
    );
    double keyLinear
    (
	double uservalue
    );
    double keyExp
    (
	double uservalue
    );

private:			// parameters of the mapping

    MapType mouseKeyMap;	// is mapping linear or exponential?

    int mouseMin;		// minimum y-value of mouse [  0]
    int mouseMax;		// minimum y-value of mouse [  0]
    double mouseSlope;		// slope used in mapping equation

    int keyMin;			// minimum y-value of key [  0]
    int keyMax;			// minimum y-value of key [  0]
    double keySlope;		// slope used in mapping equation

    double userMin;		// maximum value of user-variable
    double userMax;		// maximum value of user-variable

    CtrlFunction userControl;	// function to use values on

private:			// values of our mapped variables

    int yMouse;			// current value of mouse cursor
    int yMouseOld;		// previous value of mouse cursor
    int yKey;			// current value of key count
    int yKeyOld;		// previous value of key count
    double oldValue;		// original value of user variable

private:

    int inControl;		// set to 1 if mouse/keys are in control

};


#endif							// } TINPMOUS_h

