/************************************************************************
**
** @(#)tbox.h		06/15/93	Chris Ahlstrom
**
**	C++ version.
**
**	Defines a base class that provides only a couple things:
**
**	1.  A function called "doDialog()", that can read any old
**	    MainBox structure (see tv_menu.h), link it with a
**	    GenParameters structure, and display it all as a dialog
**	    box.
**
**	2.  A "GenParameters" structure pointer; it points to any
**	    kind of structure that contains data for a dialog box.
**
*************************************************************************/


#if !defined(TBOX_h)					// { TBOX_h
#define TBOX_h

#define Uses_TButton
#define Uses_TCheckBoxes
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TEvent
#define Uses_TInputLine
#define Uses_TLabel
#define Uses_TPoint
#define Uses_TRadioButtons
#define Uses_TRect
#define Uses_TSItem
#define Uses_TView
#include <tv.h>			// Turbo Vision functionality
#include <string.h>		// ANSI string functions

#include "tv_menu.h"		// the C++ version
#include "tinput.h"		// "Variations on TInputLine in C++", Op. 2.01
#include "tinpmous.h"		// "Variations on TInputLine in C++", Op. 3.03

#define RADIOBUTTON_PAD	5	// room for the checkmarks
#define SCROLLARROW_PAD	2	// room for TInputLine's scroll-arrows
#define LABEL_PAD	1	// handy padding for the label


/************************************************************************
** GenParameters
*************************************************************************/

typedef void *GenParameters;


/************************************************************************
** TBox
*************************************************************************/

class TBox
{

public:

    TBox				// the full-blown constructor
    (
	TDeskTop *desk,
	ExtendedDescriptor *dmap,
	MappedFieldDescriptor *fMap
    );
    TBox				// constructor without field maps
    (
	TDeskTop *desk,
	ExtendedDescriptor *dmap
    );
    TBox				// constructor without extended maps
    (
	TDeskTop *desk,
	MappedFieldDescriptor *fMap
    );
    TBox				// constructor without any maps
    (
	TDeskTop *desk
    );
    // ~TBox();

    Boolean doDialog			// data dialogs
    (
	MainBox *b,			// describes everything about box
	GenParameters p			// points to the data structure
    );
    Boolean mappedDialog
    (
	MappedBox *d,			// nested structure (tv_menu.h)
	GenParameters dialog		// general dialog structure
    );
    TView *makeField
    (
	DataType datatype,		// the exact type of boxy data item
	char **strings,			// pointer to list of button-strings
	TPoint dul,			// upper-left corner of the box
	TPoint dlr,			// lower-right corner of the box
	int maxlength,			// for TInputLine(s)
	Range& code,			// internal range of the units
	char *format,			// format of the display
	int mapped,			// is data mapping to be employed?
	Range& user,			// user-viewable range of the units
	MouseMap& map			// mouse- and arrow-mappings
    );
    TView *makeButtons
    (
	DataType type,			// the type of (we hope) boxy data
	char **list,			// pointer to list of button-strings
	TPoint dul,			// upper-left corner of the box
	TPoint dlr			// lower-right corner of the box
    );
    void buttonsOKCancel
    (
	TDialog *pd,
	TPoint lr
    );

private:				// logical functions for types

    Boolean isBox
    (
	DataType type
    );
    Boolean isNumeric
    (
	DataType type
    );
    Boolean isString
    (
	DataType type
    );
    Boolean isControl
    (
	DataType type
    );
    Boolean isExtended
    (
	DataType type
    );

public:

    TDeskTop *tBoxTop;			// indirect access to deskTop

private:

    int useDataMap;			// quick flag
    int useFieldMap;			// quick flag
    ExtendedDescriptor *dataMap;	// access to special types
    MappedFieldDescriptor *fieldMap;	// access to special types

};

#endif							// } TBOX_h

