/************************************************************************
**
** @(#)scrnmsg.c	08/11/93	Chris Ahlstrom
**
**	C version
**
**	Tentative interface between Turbo Vision and user functions.
** This interface will allow the user to write functions without much
** regard to how Turbo Vision works.
**
**	This routine is callable from a C program that knows nothing
** about Turbo-Vision, that doesn't even link in to the Turbo Vision
** libraries.  It is also callable from a C++ program.
**
*************************************************************************
**
**	I tried an experiment, loading two versions of the same
** function into a library.  The C++ version of screenmsg() should
** get name-mangled, and hence shouldn't conflict with the C version
** of screenmsg().  I was able to create a C program that found the
** regular screenmsg() [under the name _screenmsg].  But, when I created
** a C++ program, somehow the name-mangled screenmsg() function
** pre-empted access to the _screenmsg name, and it came up at link-time
** as an unresolved external.
**
**	This worked only for the Borland compiler, which detects the
** difference between a *.CPP and *.C file.
**
*************************************************************************
**
*************************************************************************/

#define SCRNMSG_c

#include <stdio.h>
#include "cnscreen.h"


/************************************************************************
** screenmsg()
**
**	This will be the primary interface for writing to the screen.
**
**	If the text is to be displayed (use_io is true), then the output
** goes to the system console if the handle is NULL.  Otherwise, it is
** assumed that the handle refered to a TWindowScreen pointer, and
** the string goes to that window.
**
** 	Defined as a macro in screnmsg.h.
**
*************************************************************************/


/************************************************************************
** cnScreenmsg()
**
**	C version of screenmsg() function.
**
*************************************************************************/

int
cnScreenmsg
(
    int use_io,				// whether to ignore output
    void *handle,			// bogus for now
    char *string			// string to display
)
{
    int err = 0;

    if (use_io)				// use the I/O
    {
	if (handle != (void *) 0)	// use console I/O
	{
	    printf
	    (
		"%%Programmer error: "
		"Can't handle anything but console I/O here\n"
	    );
	    err = 1;			// return error code
	}
	printf("%s", string);
    }
    return err;
}

