/************************************************************************
**
** @(#)screnmsg.cpp	08/10/93	Chris Ahlstrom
**
**	Tentative interface between Turbo Vision and user functions.
** This interface will allow the user to write functions without much
** regard to how Turbo Vision works.
**
**	For now, we set up an interface that duplicates console I/O.
** However, we add some parameters that are not necessary for console
** I/O, but will be necessary for Turbo Vision I/O.
**
**	Note that we want this routine to be calleable *and* *linkable*
** from a C++ ** *or* a C program.  So, we want the screenmsg() function
** to be "C", and the tvScreenmsg() function to be C++.
**
*************************************************************************/

#define SCRENMSG_cpp

#include <alloc.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "tvscreen.h"


/************************************************************************
** tvScreenmsg()
**
**	This will be the primary interface for writing to the screen
** in a TurboVision application
**
**	If the text is to be displayed (use_io is true), then the output
** goes to the system console if the handle is NULL.  Otherwise, it is
** assumed that the handle refered to a TWindowScreen pointer, and
** the string goes to that window.
**
*************************************************************************/

int
tvScreenmsg
(
    int use_io,				// whether to ignore output
    void *handle,			// bogus for now
    char *string			// string to display
)
{
    int err = 0;

    if (use_io)				// use the I/O
    {
	if (handle == NULL)		// use console I/O
	{
	    doScreenMessage
	    (
		(TWindowScreen *) handle,
		"%%Programmer error: tried to use console I/O"
		"in tvScreenmsg()... here's message anyway:\n"
	    );
	    err = 1;
	}
	doScreenMessage((TWindowScreen *) handle, string);
    }
    return err;				// return any error code
}
