/************************************************************************
**
** @(#)respwind.h	01/05/94	Chris Ahlstrom
**
** ---------------------------
**   73340.26!compuserve.com
** ---------------------------
**
** C++
**
**	This module supports showing annunciator lights in a TV window.
** The model is very strict, applicable only to 2- or 3-alternative
** forced choice tasks in psychoacoustics.  See the CPP file.
**
**	The FACE_TV (and FACE_WIN) versions are a little different from
** the code extracted from the MODAPP 2AFC-experiment code.
**
*************************************************************************/

#if !defined(RESPWIND_h)				// { RESPWIND_h
#define RESPWIND_h

#include <dos.h>
#include <conio.h>

#if !defined(__TTYPES_H)
#include <ttypes.h>		// "Boolean" Turbo Vision definition
#endif

#define Uses_TDeskTop
#define Uses_TPallete
#define Uses_TRect
#define Uses_TView
#define Uses_TWindow
#include <tv.h>			// Turbo Vision code galore!!!

#include "rbuttons.h"		// ResponseButton class
#include "respintr.h"		// ResponseInterior class


/************************************************************************
** ResponseDevice
**
**	We override the version of startScreen, in
** in order to provide the extra function of waiting for the user.
**
**	We add a responseFeedback() routine to wait for a key press
** and show the feedback lights.
**
**	Note the defining of Turbo Vision color palettes, too.
**
*************************************************************************/

#define cpBlueWindow "\x08\x09\x0A\x0B\x0C\x0D\x0E\x0F"
#define cpRespPalette cpBlueWindow	\
	RESPONSE_PAL INTERVAL_PAL READY_PAL ANSWER_PAL BACK_PAL

class ResponseDevice : public TWindow
{

public:

    ResponseDevice
    (
	ResponseType device,
	const TRect& bounds,
	const char *aTitle,
	short aNumber
    );
    ~ResponseDevice();

    ResponseSet startScreen();		// bring up initial screen
    void readyLight();			// Warning! Trial is starting!
    void responseOff();
    void intervalLight
    (
	ushort interval
    );
    void answerLight();
    int responseFeedback
    (
	int stimulus
    );
    void pause ();
    int lightMask2AFC
    (
	int stimulus,
	int response
    );

    ResponseInterior *subInterior;	// access to interior

    virtual TPalette& getPalette() const;

protected:

    ResponseButton *buttons;		// handles subject's input

};

#if 0
#if defined(RESPWIND_cpp)
    ResponseDevice *subBox;		// device window
#else
    extern ResponseDevice *subBox;	// device window
#endif
#endif



#endif							// } RESPWIND_h
