/************************************************************************
**
** @(#)respintr.h	01/03/93	Chris Ahlstrom
**
** ---------------------------
**   73340.26!compuserve.com
** ---------------------------
**
** C++
**
**	This module supports showing annunciator lights in a TV window.
** The model is very strict, applicable only to 2- or 3-alternative
** forced choice tasks in psychoacoustics.  See the CPP file.
**
**	The FACE_TV (and FACE_WIN) versions are a little different from
** the code extracted from the MODAPP 2AFC-experiment code.
**
*************************************************************************/

#if !defined(RESPINTR_h)				// { RESPINTR_h
#define RESPINTR_h

#include <dos.h>
#include <conio.h>

#if !defined(__TTYPES_H)
#include <ttypes.h>			// "Boolean" Turbo Vision definition
#endif

//#define Uses_TDeskTop
#define Uses_TRect
#define Uses_TView
//#define Uses_TWindow
#include <tv.h>				// Turbo Vision code galore!!!

// #include "delay.h"


/************************************************************************
** Constants for the Turbo Vision implementation of the light panel.
** The defines are used if it's desired to shift an interval counter
** to the proper location for a ResponseFlag of the similar name.
*************************************************************************/

typedef enum
{
    RESPONSE_NORMAL = 0,
    RESPONSE_QUIT

} ResponseSet;


#define RESP_INTV_BITS	4		/* shift'em 4 bits left for use	*/
#define RESP_OFF	0		/* the light is on		*/
#define RESP_ON		1		/* the light is on		*/


/************************************************************************
** ResponseFlag
**
**	This type employs single-bit fields to represent up to sixteen
** lights.  The bits can be OR'ed to turn on any combination of lights
** with one call.
**
**	We still need to add support for a 3-interval forced choice
** task (3AFC or 3IFC task).
**
**
** ResponseLightIndex
**
**	I'm not sure this type is used for !
**
*************************************************************************/

typedef enum
{
    RESP_1		= 0x01,		/* turn on Response 1 light	*/
    RESP_2		= 0x02,		/* turn on Response 2 light	*/
    RESP_READY		= 0x04,		/* turn on Ready light		*/
    RESP_ANSWER		= 0x08,		/* turn on Answer light		*/
    RESP_INTV_1		= 0x10,		/* turn on Interval 1 light	*/
    RESP_INTV_2		= 0x20,		/* turn on Interval 2 light	*/
    RESP_FAILURE	= 0x40,		/* programming failure light	*/
    RESP_UNUSED		= 0x80,		/* ---future expansion---	*/
    RESP_ALL_ON		= 0x3F,		/* all lights turned on		*/
    RESP_ALL_OFF	= 0x00,		/* all lights turned off	*/
    RESP_CORRECT_1	= 0x11,		/* Interval 1, Response 1	*/
    RESP_CORRECT_2	= 0x22,		/* Interval 2, Response 2	*/
    RESP_WRONG_1	= 0x12,		/* Interval 1, Response 2	*/
    RESP_WRONG_2	= 0x21		/* Interval 2, Response 1	*/

} ResponseFlag;

typedef enum
{
    FIRST_LIGHT		= 1,		/* ordinal version of above	*/
    RESPONSE_1		= 1,
    RESPONSE_2		= 2,
    READY_LIGHT		= 3,
    ANSWER_LIGHT	= 4,
    INTERVAL_1		= 5,
    INTERVAL_2		= 6,
    FAILURE_LIGHT	= 7,
    LAST_LIGHT		= 8

} ResponseLightIndex;


typedef struct
{
    int fillstyle;		// style of graphics background
    ushort color;		// color of the response light
    int x0, y0;			// pixel coordinate of upper left
    int x1, y1;			// pixel coordinate of lower right
    int status;			// 0=light off, 1=light on

} ResponseLight;


typedef struct
{
    int font;			// font to use for the text
    int direction;		// direction the lettering should go
    int charsize;		// relative size of the character
    int x0, y0;			// location of the start of the text
    char *textstring;		// the string to draw
    int status;			// 0=text off, 1=text on

} ResponseText;


/************************************************************************
** ResponseBox
**
**	A specification for the screen background, and location and sizes
** of the square response lights.
**
*************************************************************************/

typedef struct
{
    ushort background_color;
    int back_fillstyle;
    ResponseLight response_1;
    ResponseLight response_2;
    ResponseLight response_3;
    ResponseLight ready_light;
    ResponseLight answer_light;
    ResponseLight interval_1;
    ResponseLight interval_2;
    ResponseLight interval_3;
    ResponseText failure_light;

} ResponseBox;


/************************************************************************
** ResponseInterior
**
**	Since a ResponseBox is allocated in the constructor, we really
** need to add an assignment operator and copy constructor.  Later...
** (famous last word).
**
*************************************************************************/

class ResponseInterior : public TView
{

public:

    ResponseInterior			// constructor
    (
	ResponseBox& virtualbox,	// light-coordinates in virtual units
	const TRect& bounds
    );

    ~ResponseInterior ();		// destructor

    virtual void draw ();		// override TView::draw()

    void boxAspectConvert		// convert all interior lights
    (
	TRect *wbox			// window box to hold it all
    );
    void lightAspectConvert		// converts a light to text units
    (
	TRect *wbox,			// window box into which light goes
	ResponseLight& light,		// pixel-coordinates of light
	ResponseLight& text		// text-coordinate-offsets of light
    );
    void textAspectConvert		// converts text to text units
    (
	TRect *wbox,			// window box into which light goes
	ResponseText& light,		// pixel-coordinates of light
	ResponseText& text		// text-coordinate-offsets of light
    );
    void lightDraw(ResponseLight *r);	// draws one light
    void light				// sets drawing status of each light
    (
	unsigned char lightmask		// only a light with its bit on appears
    );
    void lightOn(ResponseLight *r);	// sets a light's status to RESP_ON
    void lightOff(ResponseLight *r);	// sets a light's status to RESP_OFF

protected:

    int respRows;
    int respColumns;
    int respPixelX;
    int respPixelY;

    //static ushort respBackground;	// a color

    ResponseBox *graphBox;		// light-layout in "virtual" units
    ResponseBox *textBox;		// light-layout in text units
};


#endif							// } RESPINTR_h
