/************************************************************************
**
** @(#)grafxscr.c	10/08/93	Chris Ahlstrom
**
**	A module using Borland video functions, but meant to isolate
** this "Borlandness" from caller programs.  Essentially a much tighter
** version of screen.c and screen.h.  Still requires many many functions
** in the Borland graphics library.
**
**	Used mainly when desiring to implement graphics functions.
** Some of the routines are needed in order to determine how many
** pixels or character cells are available.
**
**	This module is self-contained -- it does not refer to any
** other structures or data types.  Hence, any program can use it,
** without the need for a seemingly endless list of secondary
** include files.
**
**	See bios_vid.h for more information.
**
*************************************************************************/

#define GRAFXSCR_c

#include <dos.h>
#include <graphics.h>
#include <alloc.h>
#include <stdio.h>
#include <string.h>

#include "bios_vid.h"
#include "grafxscr.h"


/************************************************************************
** graphicsScreen()
**
**	Puts the main adapter in graphics mode, assuming the VGA
** driver is part of the executable module (see the UTIL.DOC provided
** by Borland, I believe).
**
**	See initBGI() for a more universally applicable routine.
**
*************************************************************************/

GraphicsError
graphicsScreen
(
    Screen *s
)
{
    int gdrvr = (int) DETECT;	/* start with auto-detection		*/
    int gmode = (int) VGALO;	/* start with a "zero" value		*/
    int *gd = (int *)&gdrvr;	/* use DetectGraph (if 0), or driver	*/
    int *gm = (int *)&gmode;	/* if not zero, this is graphics mode	*/
    char *dpath = "";		/* location to look for the drivers	*/
    int error;			/* a return code			*/

    if (registerbgidriver(EGAVGA_driver) < 0)
	error = grInvalidDriver;
    else if (registerbgifont(sansserif_font) < 0)
	error = grInvalidFont;
    else
    {
	*gd = DETECT;
	initgraph(gd, gm, dpath);	/* initialize graphics board	*/
	error = graphresult();		/* check the status		*/
	if (s != NULL)
	{
	    s->screen_gmax_x = getmaxx();
	    s->screen_gmax_y = getmaxy();
	}
    }
    return (GraphicsError) error;	/* return possible error code	*/
}


/************************************************************************
** setscreen()
**
**	Sets the video mode parameters.  Provides an alternative to
** setGraphicsScreen() in grafxlog.c, so that the user doesn't need
** to use the Screen structure.
**
*************************************************************************/

#pragma warn -par

int
setscreen
(
    int mode,
    int page,
    int attribute,
    int backattribute,
    int rows,
    int columns,
    int currow,
    int curcolumn,
    int curstart,
    int curend
)
{
    union REGS regs;
    int type;
    int err = 0;

    /********************************************************************
    ** Set the page number, if in the proper range.
    *********************************************************************/

    if (page >= 0 && page < 8)
    {
	regs.h.ah = VIDEO_PAGE_SELECT;
	regs.h.al = page;
	int86(VIDEO_BIOS, &regs, &regs);	/* set video page no.	*/
    }
    else
	err = 1;

    /********************************************************************
    ** Now set the mode of the page
    *********************************************************************/

    if (mode > 80)			/* supports extended modes	*/
    {
	mode += VID_TEXT_43_50;		/* IS THIS RIGHT? NO...		*/
    }
    regs.h.ah = VIDEO_MODE;
    regs.h.al = mode;
    int86(VIDEO_BIOS, &regs, &regs);	/* set cursor position		*/

    /********************************************************************
    ** Set the cursor type.
    *********************************************************************/

    type = curstart;			/* CH = starting (top) line	*/
    type = (type << 8) + curend;	/* CL = ending (bottom) line	*/
    regs.h.ah = VIDEO_CURSOR_SIZE;
    regs.x.cx = type;			/* position of cursor bounds	*/
    int86(VIDEO_BIOS, &regs, &regs);	/* set cursor position		*/

    /********************************************************************
    ** Set the cursor position.  Use desired video page.
    *********************************************************************/

    regs.h.ah = VIDEO_CURSOR_POSITION;
    regs.h.bh = page;
    regs.h.dh = currow;
    regs.h.dl = curcolumn;
    int86(VIDEO_BIOS, &regs, &regs);	/* set cursor position		*/

    setcolor(attribute);
    setbkcolor(backattribute);

    /********************************************************************
    ** We cannot set the rest, so we dummy them for now.
    ********************************************************************/

    rows	= 0;
    columns	= 0;

    return err;
}

#pragma warn .par


/************************************************************************
** getScreenType()
**
**	Replaced by getGraphicsModes() in grafxlog.c...
**
*************************************************************************/



/************************************************************************
**
** The routines above are essentially unchanged from screen.c, though
** there might be some additional functionality.
**
** The routines below attempt to handle more than one adapter card.
**
*************************************************************************/

static AdapterSelect currentAdapter;	/* selects video card to use	*/
static Screen *currentScreen;		/* equal to one of following	*/
static Screen *mainScreen;		/* points to user's setup	*/
static Screen *altScreen;		/* points to user's setup	*/


static char bgiPath[] = "C:\BC\BGI";	/* we'll use env variables later*/
#define ADAPTER_STRING	(currentAdapter ? "alternate" : "main")


Screen *
getScreenStructure (void)
{
    Screen *s = (Screen *) malloc(sizeof(Screen));
    if (s != NULL)
	s->adapter = ADAPTER_INACTIVE;	/* flag that it ain't ready yet	*/

    return s;
}


void
freeScreenStructure
(
    Screen *s
)
{
    free((void *)s);
}


void
initScreens
(
    Screen *main,
    Screen *alt
)
{
    if (main != NULL)
	mainScreen = main;
    if (alt != NULL)
	altScreen = alt;
}


int
initBGI
(
    Screen *s,				/* all screen parameters	*/
    int alt_adapter,			/* adapter to use (0 or 1)	*/
    int adapter_type			/* kind of adapter		*/
)
{
    int errcode = 0;			/* return code for errors	*/
    int xasp, yasp;			/* for reading the aspect ratio	*/
    char *bgi_path = &bgiPath[0];	/* path to find BGI support	*/
    int *gm, *gd;			/* for initgraph()		*/

    if (s->adapter != ADAPTER_INACTIVE)
    {
	printf(ERR_SCREEN_BAD);
	errcode = 2;
    }
    else
    {
	s->adapter = ADAPTER_MAIN;		/* start with main card	*/
	s->screen_driver = adapter_type;	/* get type of monitor	*/
	if (adapter_type != DETECT)
	{
	    if (adapter_type == HERCMONO)
		s->screen_mode = HERCMONOHI;
	    if (alt_adapter == ADAPTER_ALT)	/* alternate adapter?	*/
		toalternate();			/* switch to it		*/
	}

	s->adapter = alt_adapter;		/* choose the adapter	*/
	gd = (int *) &s->screen_driver;
	gm = (int *) &s->screen_mode;
	initgraph(gd, gm, bgi_path);
	s->error_code = graphresult();		/* result of initialize	*/
	if (s->error_code != grOk)		/* init error occurred	*/
	{
	    if (alt_adapter == ADAPTER_ALT)
		tomain();			/* can't use alternate!	*/
	    printf
	    (
		"%%Graphics error: %s, %s adapter\n",
		grapherrormsg(s->error_code), ADAPTER_STRING
	    );
	    errcode = 1;
	}
	else
	{
	    getpalette(&s->palette);		/* read card palette	*/
	    s->screen_colors = getmaxcolor()+1;	/* max number of colors	*/
	    s->screen_attribute	    = getcolor();
	    s->screen_backattribute = getbkcolor();

	    s->screen_gmax_x = getmaxx();
	    s->screen_gmax_y = getmaxy();	/* read size of screen	*/

	    getaspectratio(&xasp, &yasp);	/* read hardware aspect	*/
	    s->screen_aspect = (double) xasp /
		(double)yasp;			/* correction factor	*/
	}
    }
    return errcode;
}


/************************************************************************
**
**	We define VECTOR_FONT to make it easy to try out some
** other fonts.  Optionally, can also change the path where
** the fonts are stored.
**
*************************************************************************/

#define BOX_FONT	TRIPLEX_FONT	/* use Borland's fonts		*/
#define BOX_FONT_SIZE	4		/* size of normal letters	*/

int
fontinit
(
    Screen *s
)
{
    int font = BOX_FONT;
    int direction = HORIZ_DIR;
    int charsize = BOX_FONT;
    int rcode;

    if (s->adapter != ADAPTER_INACTIVE)
    {
	printf(ERR_SCREEN_BAD);
	rcode = 1;
    }
    else
	rcode = changetextstyle(s, font, direction, charsize);
    return rcode;
}


/************************************************************************
** changetextstyle()
**
**	Similar to Borland's settextstyle(), but checks for
** errors that might occur while loading the font file.
**
*************************************************************************/

int
changetextstyle
(
    Screen *s,
    int font,
    int direction,
    int charsize
)
{
    int errorcode;

    if (s->adapter == ADAPTER_MAIN)
	tomain();
    else if (s->adapter == ADAPTER_ALT)
	toalternate();
    else
	return 1;

    graphresult();			/* clear the error code		*/
    settextstyle			/* set the current output style	*/
    (
	font, direction, charsize
    );
    errorcode = graphresult();		/* check result 		*/
    if (errorcode != grOk)		/* if error occured		*/
    {
	closegraph();
	printf
	(
	    "%%Graphics error: %s, %s adapter\n",
	    grapherrormsg(errorcode), ADAPTER_STRING
	);
    }
    return errorcode;
}


void
video_main (void)
{
    asm push ds
    asm push bp
    asm mov bp,0
    asm mov ds,bp
    asm mov bp,449h
    asm mov al,7
    asm mov ds:[bp],al
    asm mov bp,463h
    asm mov bx,3b4h
    asm mov ds:[bp],bx
    asm pop bp
    asm pop ds
}


void
video_alternate (void)
{
    asm push ds
    asm push bp
    asm mov bp,0
    asm mov ds,bp
    asm mov bp,449h
    asm mov al,20
    asm mov ds:[bp],al
    asm mov bp,463h
    asm mov bx,3d4h
    asm mov ds:[bp],bx
    asm pop bp
    asm pop ds
}


void
tomain (void)
{
    video_main();
    currentAdapter = ADAPTER_MAIN;
    currentScreen = mainScreen;
}


void
toalternate (void)
{
    video_alternate();
    currentAdapter = ADAPTER_ALT;
    currentScreen = altScreen;
}


/***********************************************************************
** init1()
************************************************************************/

int
init1
(
    Screen *s,
    char *basefont
)
{
    int font = BOX_FONT;
    int direction = HORIZ_DIR;
    int charsize = BOX_FONT;
    int rcode;

    if (basefont != NULL && *basefont != '\0')
    {
	if (strcmpi("TripleXFont", basefont) == 0)
	    font = TRIPLEX_FONT;
	else if (strcmpi("DefaultFont", basefont) == 0)
	    font = DEFAULT_FONT;
	else if (strcmpi("SmallFont", basefont) == 0)
	    font = SMALL_FONT;
	else if (strcmpi("SansSerifFont", basefont) == 0)
	    font = SANS_SERIF_FONT;
	else if (strcmpi("GothicFont", basefont) == 0)
	    font = GOTHIC_FONT;
    }
    cleardevice();
    rcode = changetextstyle(s, font, direction, charsize);
    return rcode;
}


