/************************************************************************
**
** @(#)dlg_box.h	11/09/93	Chris Ahlstrom
**
**	C++
**
**	Declares the DialogBox class.  See dlg_box.cpp for full details.
**
*************************************************************************/

#if !defined(DLG_BOX_h)					// { DLG_BOX_h
#define DLG_BOX_h

#if defined(_Windows)					// { _Windows

#include "win_box.h"	// Windows class support

#else							// }{ _Windows

#include "tv_box.h"	// Turbo Vision class support

#endif							// } _Windows


//#include <stdio.h>
//#include <string.h>	// ANSI string functions

#include "tv_menu.h"	// the C++ version
#include "tinpmous.h"	// "Variations on TInputLine in C++", Op. 3.03


/************************************************************************
** GeneralDialogData
*************************************************************************/

typedef void *GeneralDialogData;


/************************************************************************
** DialogBox
*************************************************************************/

class DialogBox
{

public:

    DialogBox				// the full-blown constructor
    (
	MainBox *dialogwindow,		// nested structure (tv_menu.h)
	GeneralDialogData dialog,	// pointer to general dialog structure
	int size,			// number of bytes in the data
	DeskTop *desk,			// pointer to main display
	ExtendedDescriptor *dmap = NULL,	// special extensions
	MappedFieldDescriptor *fMap = NULL	// whole new idea
    );
    DialogBox				// constructor without extended maps
    (
	MainBox *dialogwindow,		// nested structure (tv_menu.h)
	GeneralDialogData dialog,	// pointer to general dialog structure
	int size,			// number of bytes in the data
	DeskTop *desk,
	MappedFieldDescriptor *fMap
    );
    virtual ~DialogBox();

public:					// more public interface functions

    Boolean doDialog (void);		// data dialogs
    Boolean mappedDialog (void);	// special data dialogs
    int write
    (
	FILE *fptr
    );
    int read
    (
	FILE *fptr
    );

protected:				// internal functions

    TView *makeField
    (
	DataType datatype,		// the exact type of boxy data item
	char **strings,			// pointer to list of button-strings
	TPoint dul,			// upper-left corner of the box
	TPoint dlr,			// lower-right corner of the box
	int maxlength,			// for TInputLine(s)
	Range& code,			// internal range of the units
	char *format,			// format of the display
	int mapped,			// is data mapping to be employed?
	Range& user,			// user-viewable range of the units
	MouseMap& map			// mouse- and arrow-mappings
    );
    TView *makeButtons
    (
	DataType type,			// the type of (we hope) boxy data
	char **list,			// pointer to list of button-strings
	TPoint dul,			// upper-left corner of the box
	TPoint dlr			// lower-right corner of the box
    );
    void buttonsOKCancel
    (
	TDialog *pd,
	TPoint lr
    );

private:				// logical functions for types

    Boolean isBox
    (
	DataType type
    );
    Boolean isNumeric
    (
	DataType type
    );
    Boolean isString
    (
	DataType type
    );
    Boolean isControl
    (
	DataType type
    );
    Boolean isExtended
    (
	DataType type
    );

private:

    DeskTop *boxTop;			// indirect access to deskTop

private:

    int useDataMap;			// quick flag
    int useFieldMap;			// quick flag
    ExtendedDescriptor *dataMap;	// access to special types
    MappedFieldDescriptor *fieldMap;	// access to special types

    int dataSize;			// size of the structure

    MainBox *dialogWindow;		// nested structure (tv_menu.h)
    MappedBox *mappedWindow;		// nested structure (tv_menu.h)
    GeneralDialogData dialogData;	// pointer to general dialog structure

};

#endif							// } DLG_BOX_h

