/************************************************************************
**
** @(#)bios_vid.h	11/07/91	Chris Ahlstrom
**
**  ----------------------------------
**  House Ear Institute	
**  2100 West 3rd Street, 5th Floor
**  Los Angeles, CA 90057-1902
**  (213)483-4431 voice, 483-5706 TDD
**  ----------------------------------
**
**	Defines all service codes for DOS interrupt 0x10, the
** video services.
**
**	See PC_VIDEO.H, although the present file should eventually
** supercede it.
**
**	This file is not yet finished, but it does the job!
**
*************************************************************************/

#ifndef BIOS_VID_h	/* { Allows only one incarnation of this module	*/
#define BIOS_VID_h

/*
** The SOFT_SPACE is a character used in video output to move the cursor
** in the same manner as a space, without overwriting any underlying
** characters.
**
** Note that the conversion from character to integer causes the sign
** bit to be copied.  Hence, the resultant integer is negative for
** SOFT_SPACE.  Thus I added an extra 0xFF byte.  What I really should
** do is use unsigned integers and characters, for the utmost in
** portability.  Leave it MACHINE DEPENDENT for now.
**
*/

#ifndef SOFT_SPACE
#define SOFT_SPACE	0xFFFA	/* dot character to just move cursor	*/
#define PASSIVE_CHAR	0xFFFF	/* ignore this character		*/
#define SPECIAL_CHAR	0xB1	/* make special chars visible		*/
#endif


#ifndef ATTRIBUTE	/* { avoid redefining Attr() macro many times	*/
#define ATTRIBUTE

/*
** The "Attr()" macro assembles a color byte, representing "color x on
** color y", by combining the foreground and background color nybbles.
**
*/

#define Attr(x,y)	( (x) + ((y) << 4) )

typedef int Attribute;	/* color attribute on PC is really just a byte	*/

typedef struct
{
    unsigned char ascii;	/* the PC ASCII character part of word	*/
    unsigned char color;	/* the attribute portion of the word	*/

} PC_char;


#endif			/* } ATTRIBUTE */

#ifndef ADAPTER				/* { ADAPTER			*/
#define ADAPTER

typedef enum
{
    CGA_DISPLAY,
    EGA_DISPLAY,
    VGA_DISPLAY,
    SUPER_VGA_DISPLAY,
    UNKNOWN_DISPLAY

} Adapter;

#endif					/* } ADAPTER			*/

/************************************************************************/

#define VIDEO_BIOS	0x10		/* INT number for all functions	*/

/************************************************************************/

/*
** Addresses of Video Display Area parameters updated by
** various video INT 10h functions
**
*/

#define V_DISPLAY_SEGMENT	0x0040	/* segment of this memory	*/

#define V_CRT_MODE	0x0049
#define V_CRT_COLS	0x004A
#define V_CRT_LEN	0x004C
#define V_CRT_START	0x004E
#define V_CURSOR_POSN	0x0050
#define V_CURSOR_MODE	0x0060
#define V_ACTIVE_PAGE	0x0062
#define V_ADDR_6845	0x0063
#define V_CRT_MODE_SET	0x0065
#define V_CRT_PALETTE	0x0066
#define V_ROWS		0x0084
#define V_POINTS	0x0085
#define V_INFO		0x0087		/* need to show this mask	*/
#define V_INFO_3	0x0088
#define V_DCC_Byte	0x008A



/*****************************************************************
** VIDEO_MODE
******************************************************************
**
** Input:
**
**	AH	0
**	AL	desired video mode (see list in the enum below)
**
** Output:
**
**	None
**
** Video Display Area updates:
**
**	V_CRT_MODE
**	V_CRT_COLS
**	V_CRT_LEN
**	V_CRT_START
**	V_CURSOR_POSN
**	V_CURSOR_MODE
**	V_ACTIVE_PAGE
**	V_ADDR_6845
**	V_CRT_MODE_SET
**	V_CRT_PALETTE
**	V_ROWS
**	V_POINTS
**	V_INFO
**	V_INFO_3
**
** Description:
**
**	In defining this service, and its parameters, note the following
** abbreviations:
**
**	C	CGA
**	E	EGA
**	M	MCGA
**	V	VGA
**	m	MDA
**	H	Hercules
**
** Also note the symbols that define certain default buffer segments.
**
**	Note the two masks below, which can be combined with AL to
** cause the video buffer to be cleared or not cleared when setting the
** video mode.
**
**	"BURST" refers to color bursting being enabled for a video mode.
**
*/
#define VIDEO_MODE			0x00
	
enum Video_Modes	 	/* Mode Chars Colors		Support	*/
{
    VID_TEXT_320x200,		/* 0x00	40x25	16 (gray)	CEMV H	*/
    VID_TEXT_320x200_BURST,	/* 0x01	40x25	16 (gray)	CEMV H	*/
    VID_TEXT_640x200,		/* 0x02	80x25	16		CEMV H	*/
    VID_TEXT_640x200_BURST,	/* 0x03	80x25	16		CEMV H	*/
    VID_GRAPH_320x200_BURST,	/* 0x04		 4		CEMV H	*/
    VID_GRAPH_320x200,		/* 0x05		 4 (gray)	CEMV H	*/
    VID_GRAPH_640x200_BURST,	/* 0x06		 2		CEMV H	*/
    VID_TEXT_720x350,		/* 0x07	80x25	 4		 EMVmH	*/
    VID_GRAPH_160x200_PCJR,	/* 0x08		16			*/
    VID_GRAPH_320x200_PCJR,	/* 0x09		16			*/
    VID_GRAPH_640x200_PCJR,	/* 0x0A		 4			*/
    VID_0B,			/* 0x0B	(used by EGA video BIOS 0x11)	*/
    VID_0C,			/* 0x0C	(used by EGA video BIOS 0x11)	*/
    VID_GRAPH_320x200_16,	/* 0x0D		16		 E V	*/
    VID_GRAPH_640x200_16,	/* 0x0E		16		 E V	*/
    VID_GRAPH_640x350_MONO,	/* 0x0F				 E V	*/
    VID_GRAPH_640x350_EGA,	/* 0x10		4/16		 EMV	*/
    VID_GRAPH_640x480_2,	/* 0x11		 2		  MV	*/
    VID_GRAPH_640x480_16,	/* 0x12		16		   V	*/
    VID_GRAPH_320x256_256,	/* 0x13	       256		  MV	*/
    /*
    ** Extended modes for certain VGA cards (e.g. NT-200B Super VGA)
    */
    EXT_TEXT_924x387		= 0x54,	/* 132x43  16			*/
    EXT_TEXT_924x400		= 0x55,	/* 132x25  16			*/
    EXT_TEXT_924x387_MONO	= 0x56,	/* 132x43   4			*/
    EXT_TEXT_924x400_MONO	= 0x57,	/* 132x25   4			*/
    EXT_GRAPH_800x600		= 0x58, /* 100x75  16			*/
    EXT_GRAPH_800x600_MONO	= 0x59,	/* 100x75   2			*/
    EXT_GRAPH_1024x768_MONO	= 0x5A, /* 128x48   2			*/
    EXT_GRAPH_1024x768		= 0x5B, /* 128x48   4			*/
    EXT_GRAPH_1024x768_16	= 0x5D,	/* 128x48  16			*/
    EXT_GRAPH_640x400		= 0x5E,	/*  80x25 256			*/
    EXT_GRAPH_640x480_256	= 0x5F,	/*  80x30 256			*/

    VID_HIGHEST_MODE		/* a dummy constant for convenience	*/
};

#define VID_CLEAR_BUFFER 	0x00	/* mask-clear video buffer	*/
#define VID_TEXT_43_50		0x40	/* 43 (EGA) or 50-line mode	*/
#define VID_NO_CLEAR_BUFFER  	0x80	/* don't clear video buffer	*/

#define VID_BUFFER_SEG_A	0xA000	/* For modes 0x0D to 0x13	*/
#define VID_BUFFER_SEG_B	0xB000	/* For mode 0x07		*/
#define VID_BUFFER_SEGMENT	0xB800	/* For modes 0x00 to 0x06	*/

/*
** More descriptive definitions I've used before.
*/

#define NORMAL80X25             0x02	/* normal video mode		*/
#define COLORBURSTENABLED80X25  0x03	/* displays hyphenation		*/
#define CLEARVBUFFER 	 	0x00	/* mask-clear video buffer	*/
#define NOCLEARVBUFFER  	0x80	/* don't clear video buffer	*/

/*
** Structure to hold general information about the current video mode.
**
*/

typedef struct
{
    int videomode;		/* the current video mode as above	*/
    int videopage;		/* the current video page		*/
    int columnwidth;		/* width in columns of the display	*/

} VideoModeInfo;

#ifndef __TURBOC__			/* { not __TURBOC__		*/

/*
** From conio.h, Turbo C/C++ version:
**
*/
#define BLINK		0x80	/* add to foreground color to enable it	*/

enum text_modes
{
    LASTMODE	= -1,
    BW40	= 0x00,
    C40		= 0x01,
    BW80	= 0x02,
    C80		= 0x03,
    MONO	= 0x07,
    C4350	= 0x40			/* 43- and 50-line modes	*/
};

#endif					/* } not __TURBOC__		*/


/*****************************************************************
** VIDEO_CURSOR_SIZE
******************************************************************
**
** Input:
**
**	AH	1
**	CH	starting (top) scan line of cursor
**	CL	ending (bottom) scan line of cursor
**
** Output:
**
**	None
**
** Video Display Area updates:
**
**	CX gets copied to V_CURSOR_MODE.
**
** Description:
**
**	The top line is line 0, and the bottom line is line 7 (CGA),
** 13 (EGA), and 15 (VGA).
**
**	Use this function only in a text mode.
**
**	I am not sure to truly get no cursor (set bit 5 on?), or
** how to properly pick the cursor limits given the video mode.
** For example, in 50 line mode on a VGA screen, is the character
** matrix half the height?
**
*/
#define VIDEO_CURSOR_SIZE		0x01

#define NORMALCURSOR		0x0C0D	/* hopefully, the same as DOS	*/
#define NOCURSOR		0x0000	/* no cursor at all		*/
#define FULLCURSOR		0x000F	/* full cursor in VGA mode	*/
#define SOLIDCURSOR		0x080F	/* a little too low		*/
#define EDITCURSOR		0x050C	/* chosen for good looks	*/


/*****************************************************************
** VIDEO_CURSOR_POSITION
******************************************************************
**
** Input:
**
**	AH	2
**	BH	video page number
**	DH	cursor row
**	DL	cursor column
**
** Output:
**
**	None
**
** Video Display Area updates:
**
**	V_CURSOR_POSN
**
** Description:
**
**	The row varies from 0 to 24 (25-line) or 0 to 49 (50-line).
**
**	The column varies from 0 to 39 (40-column) or 0 to 79 (80-column).
**
**	In text mode, the video page ranges from 0 to 3 (80-column), or
** from 0 to 7 (40-column).
**
**	In graphics mode, set the video page to 0.
**
*/
#define VIDEO_CURSOR_POSITION		0x02



/*****************************************************************
** VIDEO_READ_CURSOR
******************************************************************
**
** Input:
**
**	AH	3
**	BH	video page number
**	
**
** Output:
**
**	CH	top line of cursor
**	CL	bottom line of cursor
**	DH	character row
**	DL	character column
**
** Description:
**
**	Reads the appropriate values from the Video Display Area.
**
*/
#define VIDEO_READ_CURSOR		0x03



/*****************************************************************
** VIDEO_PEN_POSITION
******************************************************************
**
** Input:
**
**	AH	4
**
** Output:
**
**	AH	1 = valid position
**		0 = invalid position
**	BX	pixel x-coordinate
**	CH	pixel y-coordinate for CGA & EGA modes 4, 5, and 6
**	CX	pixel y-coordinate
**	DH	character row
**	DL	character column
**
** Description:
**
**	Reads the appropriate values from the Video Display Area.
**
*/
#define VIDEO_PEN_POSITION		0x04



/*****************************************************************
** VIDEO_PAGE_SELECT
******************************************************************
**
** Input:
**
**	AH	5
**	AL	video page number
**
** Output:
**
**	None
**
** Description:
**
**	Selects the video page (no function with CGA).  Otherwise, up
** to 8 pages are supportable.
**
**	Update V_CRT_START and V_ACTIVE_AGE in the Video Display Area.
**
*/
#define VIDEO_PAGE_SELECT		0x05



/*****************************************************************
** VIDEO_SCROLL_UP
******************************************************************
**
** Input:
**
**	AH	6
**	AL	number of lines to scroll
**	BH	color attribute of lines left blank by scrolling
**	CH	upper left corner row of rectangular area to scroll in
**	CL	upper left corner column
**	DH	lower right corner row
**	DL	lower right corner column
**	
**
** Output:
**
**	None
**
** Video Display Area updates:
**
**	None
**
** Description:
**
**	Reads the appropriate values from the Video Display Area.
**
*/
#define VIDEO_SCROLL_UP			0x06



/*****************************************************************
** VIDEO_SCROLL_DOWN
******************************************************************
**
** Input:
**
**	AH	6
**	AL	number of lines to scroll
**	BH	color attribute of lines left blank by scrolling
**	CH	upper left corner row of rectangular area to scroll in
**	CL	upper left corner column
**	DH	lower right corner row
**	DL	lower right corner column
**	
**
** Output:
**
**	None
**
** Video Display Area updates:
**
**	None
**
** Description:
**
**	Reads the appropriate values from the Video Display Area.
**
*/
#define VIDEO_SCROLL_DOWN		0x07



/*****************************************************************
** VIDEO_READ_CHARACTER
******************************************************************
**
** Input:
**
**	AH	7
**	BH	video page
**	
** Output:
**
**	AH	color attribute (text modes only)
**	AL	PC-ASCII code
**
** Video Display Area updates:
**
**	None
**
** Description:
**
**	Reads video memory to determine the character at the current
** cursor position.  In graphics mode, the bitmap at the cursor is
** looked up in the graphics-character-definition table.
**
**	In 320x200-4-color mode on EGA, MCGA, and VGA, this function
** works only for video page 0.
**
*/
#define VIDEO_READ_CHARACTER		0x08



/*****************************************************************
** VIDEO_WRITE_CHARACTER_PAIR
******************************************************************
**
** Input:
**
**	AH	9
**	AL	ASCII code
**	BH	background pixel value (320x200-256-color mode);
**		video page (all other modes)
**	BL	foreground pixel value (graphics modes);
**		color attribute (text modes)
**	CX	repetition factor (1 or greater)
**
** Output:
**
**	None
**
** Video Display Area updates:
**
**	None
**
** Description:
**
**	Write the character to the cursor position.
**
*/
#define VIDEO_WRITE_CHARACTER_PAIR	0x09



/*****************************************************************
** VIDEO_WRITE_CHARACTER
******************************************************************
**
** Input:
**
**	AH	10
**	AL	PC-ASCII code
**	BH	background pixel value (320x200-256-color mode);
**		video page (all other modes)
**	BL	foreground pixel value (graphics modes)
**	CX	repetition factor (1 or greater)
**
** Output:
**
**	AH	
**	AL	
**	BH	
**	BL
**	CH	
**	CL	
**	DH	
**	DL	
**	None
**
** Video Display Area updates:
**
**	None
**
** Description:
**
**	Write the character to the cursor position.
**
**	You can set bit 7 of BL so that the character is XORed into
** the video buffer, in graphics mode.
**
*/
#define VIDEO_WRITE_CHARACTER		0x0A



/*****************************************************************
** VIDEO_SET_OVERSCAN_PALETTE
******************************************************************
**
** Input:
**
**	AH	11
**	BH	0 = set border/background color (see #defines below)
**		1 = select 4-color palette
**	BL	color value or palette value (depends on BH).
**
** Output:
**
**	None
**
** Video Display Area updates:
**
**	CRT_PALETTE
**
** Description:
**
**	See Wilton, p. 460.
**
*/
#define VIDEO_SET_OVERSCAN_PALETTE	0x0B

/*
** Values of BL:
*/

#define VID_SET_OVERSCAN	0x00	/* set border/background color	*/
#define VID_SET_PALETTE		0x01	/* select 4-color palette	*/

/*
** Pixel values:
*/

#define V_BIT_GREEN	0x1		/* When Bit 0 of BL == 0	*/
#define V_BIT_RED	0x2
#define V_BIT_YELLOW	0x3

#define V_BIT_CYAN	0x1		/* When Bit 0 of BL == 1	*/
#define V_BIT_VIOLET	0x2
#define V_BIT_WHITE	0x3




/*****************************************************************
** VIDEO_STORE_PIXEL_VALUE
******************************************************************
**
** Input:
**
**	AH	12
**	AL	pixel value
**	BH	video page
**	CX	x-coordinate
**	DX	y-coordinate
**
** Output:
**
**	None
**
** Video Display Area updates:
**
**	None
**
** Description:
**
**	See Wilton, P. 462.
**
*/
#define VIDEO_STORE_PIXEL_VALUE		0x0C




/*****************************************************************
** VIDEO_RETURN_PIXEL_VALUE
******************************************************************
**
** Input:
**
**	AH	13
**	AL	pixel value
**	BH	video page
**	CX	x-coordinate
**	DX	y-coordinate
**
** Output:
**
**	AL	pixel value
**
** Video Display Area updates:
**
**	None
**
** Description:
**
**	See Wilton, P. 462 (including a bug report).
**
*/
#define VIDEO_RETURN_PIXEL_VALUE	0x0D



/*****************************************************************
** VIDEO_DISPLAY_TTY_CHARACTER
******************************************************************
**
** Input:
**
**	AH	14
**	AL	PC-ASCII code
**	BH	video page (PC BIOSes on or before 10/19/81)
**	BL	foreground pixel value (graphics only)
**
** Output:
**
**	None
**
** Video Display Area updates:
**
**	V_CURSOR_POSN
**
** Description:
**
**	Calls service VIDEO_WRITE_CHARACTER to display the character,
** moves the cursor, and treats the following as control codes:
**
**	0x07	Bell
**	0x08	Backspace
**	0x09	Tab (not expanded to blanks, however)
**	0x0A	Linefeed
**	0x0D	Carriage return
**
**	As in VIDEO_WRITE_CHARACTER, you can set bit 7 of BL so that
** the character is XORed into the video buffer, in graphics mode.
**	
**
**
*/
#define VIDEO_DISPLAY_TTY_CHARACTER	0x0E



/*****************************************************************
** VIDEO_STATUS
******************************************************************
**
** Input:
**
**	AH	15
**
** Output:
**
**	AH	number of displayed character columns
**	AL	video mode number
**	BH	active video page
**
** Video Display Area updates:
**
**	None
**
** Description:
**
**	Reads the appropriate values from the Video Display Area.
**
*/
#define VIDEO_STATUS			0x0F




/*****************************************************************
** VIDEO_SET_PALETTE
******************************************************************
**
** Input:
**
**	AH	16
**	AL	See below
**
**	Others	See below
**
** Output:
**
**	See below.
**
** Video Display Area updates:
**
**	V_CRT_MODE_SET
**	V_CRT_PALETTE
**
** Description:
**
**	Reads the appropriate values from the Video Display Area.
**
*/
#define VIDEO_SET_PALETTE		0x10

/*
** Values of AL:  See Wilton, pp. 466-472 for full details.
*/

enum Video_Palette_Codes
{
    VID_PALETTE,			/* 0x00				*/
    VID_OVERSCAN,			/* 0x01				*/
    VID_UPDATE_ALL,			/* 0x02				*/
    VID_BLINK,				/* 0x03				*/
    VID_READ_PALETTE		= 0x07,	/* 0x07, 04-06 unused		*/
    VID_READ_OVERSCAN,			/* 0x08				*/
    VID_READ_ALL,			/* 0x09				*/
    VID_UPDATE_DAC		= 0x10,	/* 0x10, 0A-0F unused		*/
    VID_UPDATE_DACS		= 0x12,	/* 0x12, 11 unused		*/
    VID_ATTRIB_SELECT,			/* 0x13				*/
    VID_READ_DAC		= 0x15,	/* 0x15, 14 unused		*/
    VID_READ_DACS		= 0x17,	/* 0x17, 16 unused		*/
    VID_UPDATE_DAC_MASK,		/* 0x18				*/
    VID_READ_VIDEO_DAC,			/* 0x19				*/
    VID_READ_ATTRIB_SELECT,		/* 0x1A				*/
    VID_GREY_SCALING,			/* 0x1B				*/
    VID_PALETTE_HIGHEST			/* a convenient dummy value	*/
};



/*****************************************************************
** VIDEO_CHARACTER_GENERATOR
******************************************************************
**
** Input:
**
**	AH	17
**	AL	See below.
**	Others	See below.
**
** Output:
**
**	See below.
**
** Video Display Area updates:
**
**	V_CRT_LEN
**	V_CURSOR_MODE
**	V_ROWS
**	V_POINTS
**
*/
#define VIDEO_CHARACTER_GENERATOR	0x11


/*
** Values of AL:  See Wilton, pp. 473-477 for full details.
*/

enum Video_Char_Generator
{
    VID_USER_CHARS,			/* 0x00				*/
    VID_ROM_8x14,			/* 0x01				*/
    VID_ROM_8x8,			/* 0x02				*/
    VID_RAM_SELECT,			/* 0x03				*/
    VID_ROM_8x16,			/* 0x04				*/
    VID_LOAD_USER_CHARS		= 0x10,	/* 0x10, 05-0F unused		*/
    VID_LOAD_ROM_8x14,			/* 0x11				*/
    VID_LOAD_ROM_8x8,			/* 0x12				*/
    VID_LOAD_ROM_8x16		= 0x14,	/* 0x14, 13 unused		*/
    VID_LOAD_USER_MAP_1F	= 0x20,	/* 0x20, 15-1F unused		*/
    VID_LOAD_USER_MAP,			/* 0x21				*/
    VID_LOAD_MAP_ROM_8x14,		/* 0x22				*/
    VID_LOAD_MAP_ROM_8x8,		/* 0x23				*/
    VID_LOAD_MAP_ROM_8x16,		/* 0x24				*/
    VID_GET_CHAR_INFO		= 0x30,	/* 0x30, 25-2F unused		*/
    VID_CHARS_HIGHEST			/* convenient terminator	*/
};



/*****************************************************************
** VIDEO_SUBSYSTEM
******************************************************************
**
** Input:
**
**	AH	18
**	BL	See below.
**	Others	See below.
**
** Output:
**
**	See Below.
**
** Video Display Area updates:
**
**	None
**
** Description:
**
**	Reads the appropriate values from the Video Display Area.
**
*/
#define VIDEO_SUBSYSTEM			0x12


/*
** Values of BL:  See Wilton, pp. 477-482 for full details.
*/

enum Video_Subsystem
{
    VID_SUB_READ_CONFIG		= 0x10,
    VID_SUB_ALT_PRT_SCREEN	= 0x20,
    VID_SUB_SCAN_LINES		= 0x30,
    VID_SUB_DEFAULT_PALETTE	= 0x31,
    VID_SUB_CPU_VIDEO_ACCESS,
    VID_SUB_GRAY_SCALE_SUM,
    VID_SUB_CURSOR_EMULATE,
    VID_SUB_PS2_SWITCHING,
    VID_SUB_REFRESH_CONTROL,
    VID_SUB_HIGHEST				/* terminator dummy	*/
};


/*****************************************************************
** VIDEO_DISPLAY_STRING
******************************************************************
**
** Input:
**
**	AH	19
**	AL	See values listed below.
**	BH	Video page
**	BL	Attribute
**	CX	String length
**	DH	Character row
**	DL	Character column
**	ES:BP	starting address of string
**	
**
** Output:
**
**	None
**
** Video Display Area updates:
**
**	V_CURSOR_POSN
**
** Description:
**
**	Displays the string, using control characters, and wrap-around
** and scrolling if necessary.
**
*/
#define VIDEO_DISPLAY_STRING		0x13

/*
** Values of AL (useful masks are also given):
*/

enum Video_Display_String	/* Attributes in	Cursor update?	*/
{
    VID_STRING_BL,		/*    BL		  No		*/
    VID_STRING_BL_MOVE,		/*    BL		  Yes		*/
    VID_STRING_ATTRIB,		/*   String		  No		*/
    VID_STRING_ATTRIB_MOVE	/*   String		  Yes		*/
};

/*
** If none of the following masks are used, then the Byte specifies
** VID_STRING_BL (as defined above).
*/
#define VID_STR_BL	0x01
#define VID_STR_MOVE	0x02



#define VIDEO_RESERVED_14		0x14
#define VIDEO_RESERVED_15		0x15
#define VIDEO_RESERVED_16		0x16
#define VIDEO_RESERVED_17		0x17
#define VIDEO_RESERVED_18		0x18
#define VIDEO_RESERVED_19		0x19




/*****************************************************************
** VIDEO_DISPLAY_COMBINATION
******************************************************************
**
** Input:
**
**	AH	26
**	AL	See #defines below
**
** Output:
**
**	AL = VID_DISPLAY_READ
**
**		AL	= 0x1A
**		BH	inactive display
**		BL	active display
**
**	AL = VID_DISPLAY_SET
**
**		AL	= 0x1A
**
** Video Display Area updates:
**
**	V_DCC_Byte
**
** Description:
**
**	Reads the appropriate values from the Video Display Area.
**
*/
#define VIDEO_DISPLAY_COMBINATION	0x1A




/*****************************************************************
** VIDEO_BIOS_STATE
******************************************************************
**
** Input:
**
**	AH	27
**	BX	implementation type (must be 0)
**	ES:DI	address of 64-Byte buffer
**
** Output:
**
**	AL	= 0x1B
**	ES:DI	buffer updated with function and state information
**
** Video Display Area updates:
**
**	None
**
** Description:
**
**	Reads the appropriate values from the Video Display Area.
**
**	See the structure below.
**
*/
#define VIDEO_BIOS_STATE		0x1B

/*
** The following definitions are valid only on the PC.
** And there here only for awhile.
** And we require use of the far pointers.
*/

typedef long Dword;
typedef int Word;
typedef unsigned char Byte;

typedef struct
{
    Byte vmodes_supported[3];		/* mode i mapped to bit i	*/
    Byte sft_reserved[4];
    Byte raster_lines_supported;	/* see bit map			*/
    Byte max_character_sets;
    Byte max_chardef_tables;
    Byte misc_abilities;		/* see bit map			*/
    Byte misc_BIOS_abilities;		/* see bit map			*/
    Byte sft_reverved_2[2];
    Byte save_area_abilities;		/* see bit map			*/
    Byte sft_reserved_3;

} Static_Function_Table;

typedef struct
{
    Byte column;
    Byte row;

} Cursor_Coordinate;


typedef struct
{
    Static_Function_Table *SFT;
    Byte mode;
    Word character_columns;
    Word buffer_displayed_length;
    Word buffer_start;
    Cursor_Coordinate cursor[8];
    Byte cursor_end_line;
    Byte cursor_start_line;
    Byte active_video_page;
    Word CRTC_IO_port;
    Byte crt_mode_set;
    Byte crt_palette;
    Byte number_of_rows;
    Word points_in_character;
    Byte active_display;
    Byte inactive_display;
    Word colors_in_display;
    Byte pages_supported;
    Byte raster_lines;
    Byte alpha_table_0;
    Byte alpha_table_1;
    Byte misc_state;
    Byte reserved[3];
    Byte video_RAM_size;
    Byte save_area_status;

} Video_BIOS_State;

#ifdef USE_VIDEO_STATICS
#ifndef VIDEO_ALLOCATION
#define VIDEO_ALLOCATION

static int raster_code[] = { 200, 350, 400, 480 };
static int RAM_sizes[] = { 64, 128, 192, 256 };		/* sizes in K	*/

#endif
#endif

#define BIT0	((Byte) 0x01)
#define BIT1	((Byte) 0x02)
#define BIT2	((Byte) 0x04)
#define BIT3	((Byte) 0x08)
#define BIT4	((Byte) 0x10)
#define BIT5	((Byte) 0x20)
#define BIT6	((Byte) 0x40)
#define BIT7	((Byte) 0x80)

#define RASTER_200		BIT0	/* Bits for raster_lines supp'd	*/
#define RASTER_350		BIT1
#define RASTER_400		BIT2

#define LIGHT_PEN_SUPPORT	BIT0	/* Bits for misc_BIOS_abilities	*/
#define SAVE_RESTORE_VSTATE	BIT1
#define BLINK_BACKGROUND_INTENS	BIT2
#define DISPLAY_COMBO_CODE	BIT3
#define mBa_RESERVED4		BIT4
#define mBa_RESERVED5		BIT5
#define mBa_RESERVED6		BIT6
#define mBa_RESERVED7		BIT7

#define MULTIPLE_CHARSETS	BIT0	/* Bits for save_area_abilities	*/
#define DYNAMIC_SAVE_AREA	BIT1
#define ALPHA_CHARSET_OVERRIDE	BIT2
#define GRAPH_CHARSET_OVERRIDE	BIT3
#define PALETTE_OVERRIDE	BIT4
#define DISPLAY_COMBO_CODE_EXT	BIT5
#define saa_RESERVED6		BIT6
#define saa_RESERVED7		BIT7

#define ALL_MODES_ALL_MONITORS	BIT0	/* Bits for misc_abilities	*/
#define GREY_SCALE_SUMMING	BIT1
#define CHARSET_LOADING		BIT2
#define DEF_PALETTE_LOADING	BIT3
#define CURSOR_EMULATION	BIT4
#define PALETTE_64_COLOR	BIT5
#define VIDEO_DAC_LOADING	BIT6
#define VIDEO_DAC_CONTROL	BIT7

#define ALL_MODES_ACTIVE	BIT0	/* Bits for misc_state		*/
#define GREY_SCALE_SUM_ON	BIT1
#define MONOCHROME_ATTACHED	BIT2
#define LOAD_DEF_PALETTE_OFF	BIT3
#define CURSOR_EMULATION_ON	BIT4
#define BLINKING_ON		BIT5
#define MS_RESERVED6		BIT6
#define MS_RESERVED7		BIT7

#define TWO_CHARSETS		BIT0	/* Bits for save_area_status	*/
#define DYNAMIC_SAVE		BIT1
#define ALPHA_SET_OVERRIDE	BIT2
#define GRAPHICS_SET_OVERRIDE	BIT3
#define PALETTE_OVERRIDE	BIT4
#define DISPLAY_COMBO_EXTENSION	BIT5
#define SAS_RESERVED6		BIT6
#define SAS_RESERVED7		BIT7

/*****************************************************************
** VIDEO_STATE			//// laterrrrrr /////////
******************************************************************
**
** Input:
**
**	AH	0
**	AL	
**	BH	
**	BL
**	CH	
**	CL	
**	DH	
**	DL	
**	
**
** Output:
**
**	AH	
**	AL	
**	BH	
**	BL
**	CH	
**	CL	
**	DH	
**	DL	
**	None
**
** Video Display Area updates:
**
**	None
**
** Description:
**
**	Reads the appropriate values from the Video Display Area.
**
*/
#define VIDEO_STATE			0x1C



/*****************************************************************
** VIDEO_
******************************************************************
**
** Input:
**
**	AH	0
**	AL	
**	BH	
**	BL
**	CH	
**	CL	
**	DH	
**	DL	
**	
**
** Output:
**
**	AH	
**	AL	
**	BH	
**	BL
**	CH	
**	CL	
**	DH	
**	DL	
**	None
**
** Video Display Area updates:
**
**	None
**
** Description:
**
**	Reads the appropriate values from the Video Display Area.
**
*/



/****************************************************************
** CONVENIENCES FOR VIDEO USAGE ON THE IBM PC
*****************************************************************/

#ifndef PC_ADDRESSING			/* { PC segmentation	*/
#define PC_ADDRESSING

#define ADDR_80x86(a, b) (b),(a)        /* Swap order of args   */
#define VIDEOPN 0xB800                  /* Video page 1 segment */

/*
** These definitions are almost the same as FP_SEG and FP_OFF in 
** "dos.h".  We must emphasize here that they work only on pointers... 
** NOT on array identifiers or register pointers.
*/

#define SEGMENT(farp) (Word)(*((unsigned *)&(farp) + 1))
#define OFFSET(farp) (Word)(*((unsigned *)&(farp)))

#endif					/* } PC_ADDRESSING	*/


/****************************************************************
** STANDARD COLOR ATTRIBUTE NYBBLES for IBM CGA DISPLAY
*****************************************************************
**
**	These symbols are a superset of those in Turbo C, as
** defined in conio.h.
**
*/

#if !defined(__COLORS)		/* { PC color schemes			*/
#define __COLORS

#define BRIGHT		0x08
#define DIM		0x00

enum COLORS
{
    BLACK		= 0x00,
    BLUE		= 0x01,
    GREEN		= 0x02,
    CYAN		= 0x03,
    RED			= 0x04,
    MAGENTA		= 0x05,
    BROWN		= 0x06,
    LIGHTGRAY		= 0x07,
    DARKGRAY		= (BRIGHT|BLACK),	/* 0x08	*/
    LIGHTBLUE		= (BRIGHT|BLUE),	/* 0x09	*/
    LIGHTGREEN		= (BRIGHT|GREEN),	/* 0x0A	*/
    LIGHTCYAN		= (BRIGHT|CYAN),	/* 0x0B	*/
    LIGHTRED		= (BRIGHT|RED),		/* 0x0C	*/
    LIGHTMAGENTA	= (BRIGHT|MAGENTA),	/* 0x0D	*/
    YELLOW		= (BRIGHT|BROWN),	/* 0x0E	*/
    WHITE		= (BRIGHT|LIGHTGRAY)	/* 0x0F	*/
};

#define GRAY		(BRIGHT|BLACK)
#define GREY		(BRIGHT|BLACK)

#endif				/* } __COLORS				*/

#endif			/* } BIOS_VID_h					*/
