/*                            SAMPLE10.C

   Using windwrite() to write text strings to a window on screen.
   This is very usefull for printing short help or error messages. 
*/
#include <window.h1>

char  *stringtoprint="This is text placed in a window using the function "
                     "windwrite. Notice how the word wrap is is performed "
                     "automatically for you.  If the string won't fit in the "
                     "length of the window, a flashing 'more' will appear in "
                     "the last row.";
main()
{
   initwindows(DOUBLE,GREEN,WHITE,GREEN,BLACK);
   scrncolor(BLUE,LTGRAY);

   /* Open a window in which to place text.  Don't make the window
      too narrow or the word wrap will give a strange presentation.
      In fact if the window is narrower than the widest word in the
      string to be printed, the word wrap will be thoroughly confused.*/

   makewindow(1,7,25,17,65,"Sample Text Window",SHADOW);

   /* Now send a pointer to a string to windwrite().  Windwrite will
      automatically do word wrap for you adjusting to the width of the
      window.*/

   windwrite(1,stringtoprint,1,1);	/* The coordinates are relative to the
	                                   text area of the window.*/
   windwrite(1,"Hit enter to continue.",9,10);
   while(getche() != 13)
      ;
   /* Here is an example of what happens if the string is too large to
      fit in the height of the window.*/

   makewindow(2,10,30,15,70,"Shallow Text Window",SHADOW);
   windwrite(2,stringtoprint,1,1);
   windwrite(2,"Hit any key to continue.",4,10);
   while(!kbhit())
      ;

   removewindow(2);  /* remove windows in reverse order */
   removewindow(1);
   scrncolor(BLACK,LTGRAY);
}
