/*                            SAMPLE09.C

   Putting it all together.  Creating 'pull-down' type menus with explosions
   and sound effects.  This combines both horizontal and vertical type menus
   and demonstrates having more than active window on the screen at once. 
*/
#include <window.h1>  /* All programs using EZWINDOW must include
                         this header file.*/
char c;

main()
{
   initwindows(DOUBLE,GREEN,WHITE,GREEN,BLACK); /* Must always be called
                                                   before any other
                                                   EZWINDOW functions */
   snapshot(); /* store the current screen */
   clrscr(); /* clear the screen.*/
   cursoroff(); /* turn the cursor off till we restore screen */
   scrncolor(BLUE,LTGRAY); /* set screen background color to BLUE
	                      and background text to LTGRAY.*/

   SOUND = ON;

   /* Create a window wide enough to hold all menu choices while
      leaving a little space between choices for appearance sake.
      Don't go to the trouble of exactly measuring the menu spacing,
      EZWINDOW will automatically center your menu selections for you.
      Making the menu 3 rows deep gives a good appearance but it can
      be deeper.  EZWINDOW will also center your menu selections
      vertically.*/

   explodewindow(1,3,3,5,75,"Horizontal Menubar Example",SHADOW);

   /* initchoicesh() will now center your menu selections both
      horizontally and vertically.  You may have to massage the
      window size or position to produce the best appearance in
      your own programs. This function also creates a reverse video
      'menubar' and positions it on your first menu selection.*/

   initchoicesh(1,"CHOICE 1,CHOICE 2,CHOICE 3,CHOICE 4,QUIT");

   /* Now use getchoice() to return the selected menu option. getchoice()
      allows you to use the arrow keys to move the menubar. Hitting
      enter makes the selection.*/

   while ((c = getchoice(1)) != 5)  /* Continue getting selections until
	                               QUIT is selected.*/
      switch(c)
      {
        	case 1 :
     	   /* Create a new window starting at the bottom row of window 1 */
           explodewindow(2,5,5,11,16,"",SHADOW);
       	   initchoicesv(2,"CHOICE 1,CHOICE 2,CHOICE 3,CHOICE 4,QUIT");
           while(getchoice(2) != 5)
              ;
           removewindow(2);
           break;
        case 2 :
           /* Create a new window starting at the bottom row of window 1 */
           explodewindow(2,5,20,11,31,"",SHADOW);
           initchoicesv(2,"CHOICE 1,CHOICE 2,CHOICE 3,CHOICE 4,QUIT");
           while(getchoice(2) != 5)
              ;
           removewindow(2);
           break;
        case 3 :
           /* Create a new window starting at the bottom row of window 1 */
           explodewindow(2,5,35,11,46,"",SHADOW);
           initchoicesv(2,"CHOICE 1,CHOICE 2,CHOICE 3,CHOICE 4,QUIT");
           while(getchoice(2) != 5)
              ;
           removewindow(2);
           break;
        case 4 :
           /* Create a new window starting at the bottom row of window 1 */
           explodewindow(2,5,50,11,61,"",SHADOW);
           initchoicesv(2,"CHOICE 1,CHOICE 2,CHOICE 3,CHOICE 4,QUIT");
           while(getchoice(2) != 5)
              ;
           removewindow(2);
           break;
      }
      removewindow(1); /* remove window 1 from the screen */
      develop(); /* restore the original screen */
      cursoron(); /* turn the cursor back on */
}

