/*                          SAMPLE11.C

   Using filetowindow() to write text files to a window on screen.
   This is particularly usefull for presenting context sensitive help
   from within your program. */

#include <window.h1>

main()
{
   initwindows(DOUBLE,GREEN,WHITE,GREEN,BLACK);
   scrncolor(BLUE,LTGRAY);

   /* Open a window in which to place text.  Don't make the window
      too narrow or the word wrap will give a strange presentation.
      In fact if the window is narrower than the widest word in the
      file to be printed, the word wrap will be thoroughly confused.*/

   makewindow(1,7,25,17,65,"Sample Text Window",SHADOW);

   /* Now send a file name to filetowindow().  filetowindow() will
      open the file and print it on the screen automatically doing
      word wrap for you adjusting  to the width of the window.
      When the entire file has been printed it will be closed for you. */

   filetowindow(1,"sample.txt",1,2); /* The coordinates are relative to the
                                        text area of the window. The starting
                                        row is used only for the first page of
                                        output.  From then on new pages always
                                        start at row 1.  The starting column is
                                        used for all pages. */

   windwrite(1,"Hit enter to continue.",9,10);
   while(getch() != 13)
      ;
   removewindow(1);
   scrncolor(BLACK,LTGRAY);
}

/*
  Important note: When creating files for automatic insertion and
word wrap in windows, it is necessary for the window formatting routine
to be able to distinguish between 'hard' and 'soft' carriage returns.
Soft returns are those which you used simply to write your file in normal
80 - column format.  In other words they have nothing to do with formatting
text or numbers in their eventual windowed environment.  Hard carriage returns,
on the other hand, are returns you inserted because you wanted to format the
text or numbers in the window.  An example of a hard return is the end of a
paragraph. Another example is in formatting columns of numbers. For example:

     COL1       COL2     COL3
     100        200      300
     200        300      400
     ___        ___      ___
 tot xxx        xxx      xxx

        The type carriage return is detected by looking ahead to the next
character after a carriage return is read from the input file.  If the next
character is alphanumeric then the carriage return is considered 'soft'.  If
the character following the return is a space or another return, then the
return is considered hard and will be used in the window formatting of the
text. For exapmple, consider the following examples:

Ex#1:
     100    200
     200    300
     ___    ___
tot  xxx    xxx

Ex#2:
     100    200
     200    300
     ___    ___
 tot xxx    xxx

     Although these two examples look almost identical, only Example# 2
will format correctly in a window.  Everything will work fine until the last
line in Example# 1.  It is intended that there be a hard carriage return
preceding the word 'tot'.  However since 'tot' starts in column 1, the hard
return is interpretted as soft.  The solution is shown in Example# 2 where
the word 'tot' starts in column 2.
     This quirk is the price to be paid for the luxury of automatic word
wrapping in any size window with any ASCII text file.

*/
