/*                        SAMPLE08.C

   Creating an 'exploding' window.  That is a window which starts
   at its center and 'explodes' outward.  Here is the same vertical menu
   with sound effects as found in sample07.c but this time the window will
   'explode' onto the screen. NOTE: with AT class machines and faster
   the explosion is almost indistinguishable - especially with EGA
   monitors.  Notice that the exploding windows are created by using the
   function explodewindow() instead of makewindow(). 
*/
#include <window.h1>  /* All programs using EZWINDOW must include
                         this header file.*/
main()
{
   initwindows(DOUBLE,GREEN,WHITE,GREEN,BLACK); /* Must always be called
                                                   before any other
                                                   EZWINDOW functions */
   snapshot(); /* store the current screen */
   clrscr(); /* clear the screen.*/
   cursoroff(); /* turn the cursor off till we restore screen */
   scrncolor(BLUE,LTGRAY); /* set screen background color to BLUE
                              and background text to LTGRAY.*/

   SOUND = ON;  /* This is how sound effects are turned on.  SOUND and ON
                   are found in window.h1. */

   /* To decide on the vertical size of the window first decide whether
      you want single spacing or double spacing between selections.  For
      double spacing take the number of choices X 2 and add a space above
      the first choice and below the second. In this example we have five
      selections so we use a vertical window size of 12. For single spacing
      use a vertical size equal to the number of menu choices + 1.

      The window width should allow for the width of the widest selection
      or the title, whichever is wider, plus a couple of columns for
      appearance sake. The selections in the window will be automatically
      centered for you horizontally. You may have to adjust the height and/or
      width for the best appearence. */

   explodewindow(1,5,26,17,54,"Vertical Menubar Example",SHADOW);

   /* initchoicesv() will now center your menu selections both
      horizontally and vertically.  You may have to massage the
      window size or position to produce the best appearance in
      your own programs. This function also creates a reverse video
      'menubar' and positions it on your first menu selection.*/

   initchoicesv(1,"CHOICE 1,CHOICE 2,CHOICE 3,CHOICE 4,QUIT");

   /* Now use getchoice() to return the selected menu option. getchoice()
      allows you to use the arrow keys to move the menubar. Hitting
      enter makes the selection.*/

   while (getchoice(1) != 5)  /* Continue getting selections until
	                         QUIT is selected.*/
     	;

   removewindow(1); /* remove window 1 from the screen */
   develop(); /* restore the original screen */
   cursoron(); /* turn the cursor back on */
}
